/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.ProvUIProvisioningListener;
import org.eclipse.equinox.internal.p2.ui.QueryProvider;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.viewers.IUColumnConfig;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.query.CategoryQuery;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProvUI {
    public static final String INSTALL_COMMAND_LABEL = ProvUIMessages.InstallIUCommandLabel;
    public static final String INSTALL_COMMAND_TOOLTIP = ProvUIMessages.InstallIUCommandTooltip;
    public static final String UNINSTALL_COMMAND_LABEL = ProvUIMessages.UninstallIUCommandLabel;
    public static final String UNINSTALL_COMMAND_TOOLTIP = ProvUIMessages.UninstallIUCommandTooltip;
    public static final String UPDATE_COMMAND_LABEL = ProvUIMessages.UpdateIUCommandLabel;
    public static final String UPDATE_COMMAND_TOOLTIP = ProvUIMessages.UpdateIUCommandTooltip;
    public static final String REVERT_COMMAND_LABEL = ProvUIMessages.RevertIUCommandLabel;
    public static final String REVERT_COMMAND_TOOLTIP = ProvUIMessages.RevertIUCommandTooltip;
    private static IUColumnConfig[] columnConfig;
    private static QueryProvider queryProvider;
    private static final String UPDATE_MANAGER_FIND_AND_INSTALL = "org.eclipse.ui.update.findAndInstallUpdates";
    private static final String UPDATE_MANAGER_MANAGE_CONFIGURATION = "org.eclipse.ui.update.manageConfiguration";
    private static final String INSTALLATION_DIALOG = "org.eclipse.ui.help.installationDialog";

    public static IStatus handleException(Throwable t, String message, int style) {
        if (message == null && t != null) {
            message = t.getMessage();
        }
        Status status = new Status(4, "org.eclipse.equinox.p2.ui", 0, message, t);
        StatusManager.getManager().handle((IStatus)status, style);
        return status;
    }

    public static void reportStatus(IStatus status, int style) {
        if ((style & 4) == 4 || (style & 2) == 2) {
            if (status.getSeverity() == 1) {
                MessageDialog.openInformation((Shell)ProvUI.getDefaultParentShell(), (String)ProvUIMessages.ProvUI_InformationTitle, (String)status.getMessage());
                style &= 0xFFFFFFFB;
                style &= 0xFFFFFFFD;
                if (status.getCode() == 10000) {
                    style = 0;
                }
            } else if (status.getSeverity() == 2) {
                MessageDialog.openWarning((Shell)ProvUI.getDefaultParentShell(), (String)ProvUIMessages.ProvUI_WarningTitle, (String)status.getMessage());
                style &= 0xFFFFFFFB;
                style &= 0xFFFFFFFD;
            }
        }
        if (style != 0) {
            StatusManager.getManager().handle(status, style);
        }
    }

    public static IUColumnConfig[] getIUColumnConfig() {
        if (columnConfig == null) {
            columnConfig = new IUColumnConfig[]{new IUColumnConfig(ProvUIMessages.ProvUI_NameColumnTitle, 1, 60), new IUColumnConfig(ProvUIMessages.ProvUI_VersionColumnTitle, 2, 40)};
        }
        return columnConfig;
    }

    public static IUViewQueryContext getQueryContext(Policy policy) {
        IUViewQueryContext queryContext = new IUViewQueryContext(policy.getGroupByCategory() ? 1 : 3);
        queryContext.setShowLatestVersionsOnly(policy.getShowLatestVersionsOnly());
        queryContext.setShowInstallChildren(policy.getShowDrilldownRequirements());
        queryContext.setShowProvisioningPlanChildren(policy.getShowDrilldownRequirements());
        queryContext.setUseCategories(policy.getGroupByCategory());
        return queryContext;
    }

    public static <T> T getAdapter(Object object, Class<T> adapterType) {
        if (object == null) {
            return null;
        }
        if (adapterType.isInstance(object)) {
            return (T)object;
        }
        if (object instanceof IAdaptable) {
            return (T)((IAdaptable)object).getAdapter(adapterType);
        }
        return null;
    }

    public static Shell getDefaultParentShell() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Shell shell = ProvUI.getDefaultParentShell(workbench.getDisplay().getShells());
        if (shell != null) {
            return shell;
        }
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        if (windows.length > 0) {
            return windows[0].getShell();
        }
        return null;
    }

    private static Shell getDefaultParentShell(Shell[] shells) {
        int i = shells.length - 1;
        while (i >= 0) {
            Shell shell = shells[i];
            Shell modalChild = ProvUI.getDefaultParentShell(shell.getShells());
            if (modalChild != null) {
                return modalChild;
            }
            if (shell.isVisible()) {
                int modal = 229376;
                if ((shell.getStyle() & modal) != 0) {
                    return shell;
                }
            }
            --i;
        }
        return null;
    }

    public static void addProvisioningListener(ProvUIProvisioningListener listener) {
        ProvUIActivator.getDefault().addProvisioningListener(listener);
    }

    public static void removeProvisioningListener(ProvUIProvisioningListener listener) {
        ProvUIActivator.getDefault().removeProvisioningListener(listener);
    }

    public static void openUpdateManagerInstaller(Event event) {
        ProvUI.runCommand(UPDATE_MANAGER_FIND_AND_INSTALL, ProvUIMessages.UpdateManagerCompatibility_UnableToOpenFindAndInstall, event);
    }

    public static void openUpdateManagerConfigurationManager(Event event) {
        ProvUI.runCommand(UPDATE_MANAGER_MANAGE_CONFIGURATION, ProvUIMessages.UpdateManagerCompatibility_UnableToOpenManageConfiguration, event);
    }

    public static void openInstallationDialog(Event event) {
        ProvUI.runCommand(INSTALLATION_DIALOG, ProvUIMessages.ProvUI_InstallDialogError, event);
    }

    public static QueryProvider getQueryProvider() {
        if (queryProvider == null) {
            queryProvider = new QueryProvider(ProvUIActivator.getDefault().getProvisioningUI());
        }
        return queryProvider;
    }

    private static void runCommand(String commandId, String errorMessage, Event event) {
        Class<?> clazz;
        Class<?> clazz2;
        try {
            clazz2 = Class.forName("org.eclipse.ui.commands.ICommandService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(clazz2);
        Command command = commandService.getCommand(commandId);
        if (!command.isDefined()) {
            return;
        }
        try {
            clazz = Class.forName("org.eclipse.ui.handlers.IHandlerService");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(clazz);
        try {
            handlerService.executeCommand(commandId, event);
        }
        catch (ExecutionException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotDefinedException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotEnabledException e) {
            ProvUI.reportFail(errorMessage, e);
        }
        catch (NotHandledException e) {
            ProvUI.reportFail(errorMessage, e);
        }
    }

    public static boolean isCategory(IInstallableUnit iu) {
        return CategoryQuery.isCategory((IInstallableUnit)iu);
    }

    private static void reportFail(String message, Throwable t) {
        Status failStatus = new Status(4, "org.eclipse.equinox.p2.ui", message, t);
        ProvUI.reportStatus((IStatus)failStatus, 5);
    }

    public static void setQueryProvider(QueryProvider provider) {
        queryProvider = provider;
    }
}

