/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.RepositoryLocationQuery;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRepository;
import org.eclipse.equinox.p2.repository.IRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueryableRepositoryManager<T>
implements IQueryable<T> {
    private ProvisioningSession session;
    protected boolean includeDisabledRepos;
    protected RepositoryTracker tracker;
    protected int repositoryFlags;
    protected ProvisioningUI ui;

    public QueryableRepositoryManager(ProvisioningUI ui, boolean includeDisabledRepos) {
        this.includeDisabledRepos = includeDisabledRepos;
        this.ui = ui;
        this.tracker = ui.getRepositoryTracker();
        this.session = ui.getSession();
        this.repositoryFlags = this.getRepositoryFlags(this.tracker);
    }

    protected ProvisioningSession getSession() {
        return this.session;
    }

    public IQueryResult<T> query(IQuery<T> query, IProgressMonitor monitor) {
        IRepositoryManager<T> manager = this.getRepositoryManager();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        return this.query(this.getRepoLocations(manager), query, monitor);
    }

    public IQueryable<URI> locationsQueriable() {
        return new IQueryable<URI>(){

            public IQueryResult<URI> query(IQuery<URI> query, IProgressMonitor monitor) {
                return query.perform(Arrays.asList(QueryableRepositoryManager.this.getRepoLocations(QueryableRepositoryManager.this.getRepositoryManager())).iterator());
            }
        };
    }

    protected URI[] getRepoLocations(IRepositoryManager<T> manager) {
        HashSet<URI> locations = new HashSet<URI>();
        locations.addAll(Arrays.asList(manager.getKnownRepositories(this.repositoryFlags)));
        if (this.includeDisabledRepos) {
            locations.addAll(Arrays.asList(manager.getKnownRepositories(8 | this.repositoryFlags)));
        }
        return locations.toArray(new URI[locations.size()]);
    }

    public boolean areRepositoriesLoaded() {
        IRepositoryManager<T> mgr = this.getRepositoryManager();
        if (mgr == null) {
            return false;
        }
        URI[] repoURIs = this.getRepoLocations(mgr);
        int i = 0;
        while (i < repoURIs.length) {
            IRepository<T> repo = this.getRepository(mgr, repoURIs[i]);
            if (repo == null && !this.tracker.hasNotFoundStatusBeenReported(repoURIs[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected abstract IRepository<T> getRepository(IRepositoryManager<T> var1, URI var2);

    protected IRepository<T> loadRepository(IRepositoryManager<T> manager, URI location, IProgressMonitor monitor) throws ProvisionException {
        monitor.setTaskName(NLS.bind((String)ProvUIMessages.QueryableMetadataRepositoryManager_LoadRepositoryProgress, (Object)URIUtil.toUnencodedString((URI)location)));
        IRepository<T> repo = this.doLoadRepository(manager, location, monitor);
        return repo;
    }

    protected abstract IRepositoryManager<T> getRepositoryManager();

    protected abstract int getRepositoryFlags(RepositoryTracker var1);

    protected abstract IRepository<T> doLoadRepository(IRepositoryManager<T> var1, URI var2, IProgressMonitor var3) throws ProvisionException;

    protected IQueryResult<T> query(URI[] uris, IQuery<T> query, IProgressMonitor monitor) {
        if (query instanceof RepositoryLocationQuery) {
            return this.locationsQueriable().query(query, monitor);
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (int)((uris.length + 1) * 100));
        ArrayList<IRepository<T>> loadedRepos = new ArrayList<IRepository<T>>(uris.length);
        int i = 0;
        while (i < uris.length) {
            IRepository<T> repo = null;
            try {
                repo = this.loadRepository(this.getRepositoryManager(), uris[i], (IProgressMonitor)sub.newChild(100));
            }
            catch (ProvisionException e) {
                this.tracker.reportLoadFailure(uris[i], e);
            }
            catch (OperationCanceledException operationCanceledException) {
                repo = null;
            }
            if (repo != null) {
                loadedRepos.add(repo);
            }
            ++i;
        }
        if (loadedRepos.size() > 0) {
            return new CompoundQueryable(loadedRepos).query(query, (IProgressMonitor)sub.newChild(100));
        }
        return Collector.emptyCollector();
    }

    public void setRespositoryFlags(int flags) {
        this.repositoryFlags = flags;
    }
}

