/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.actions;

import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.actions.ProfileModificationAction;
import org.eclipse.equinox.internal.p2.ui.model.AvailableIUElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.InstalledIUElement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.InstallOperation;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ISelectionProvider;

public class InstallAction
extends ProfileModificationAction {
    public InstallAction(ProvisioningUI ui, ISelectionProvider selectionProvider, String profileId) {
        super(ui, ProvUI.INSTALL_COMMAND_LABEL, selectionProvider, profileId);
        this.setToolTipText(ProvUI.INSTALL_COMMAND_TOOLTIP);
    }

    protected boolean isEnabledFor(Object[] selectionArray) {
        if (selectionArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < selectionArray.length) {
            Class<?> clazz;
            if (selectionArray[i] instanceof InstalledIUElement && this.isSelectable((IIUElement)selectionArray[i])) {
                return true;
            }
            try {
                clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter(selectionArray[i], clazz);
            if (iu != null && this.isSelectable(iu)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean isSelectable(IIUElement element) {
        return super.isSelectable(element) && !(element.getParent(element) instanceof AvailableIUElement);
    }

    protected int performAction(ProfileChangeOperation operation, IInstallableUnit[] ius) {
        return this.getProvisioningUI().openInstallWizard(this.getShell(), ius, (InstallOperation)operation, null);
    }

    protected ProfileChangeOperation getProfileChangeOperation(IInstallableUnit[] ius) {
        InstallOperation op = new InstallOperation(this.getSession(), ius);
        op.setProfileId(this.profileId);
        return op;
    }
}

