/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.QueryProvider;
import org.eclipse.equinox.internal.p2.ui.actions.ProvisioningAction;
import org.eclipse.equinox.internal.p2.ui.model.CategoryElement;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningJob;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.PlatformUI;

public abstract class ProfileModificationAction
extends ProvisioningAction {
    public static final int ACTION_NOT_RUN = -1;
    String profileId;
    String userChosenProfileId;
    int result = -1;

    protected ProfileModificationAction(ProvisioningUI ui, String text, ISelectionProvider selectionProvider, String profileId) {
        super(ui, text, selectionProvider);
        this.ui = ui;
        this.profileId = profileId;
        this.init();
    }

    public void run() {
        IInstallableUnit[] ius = this.getSelectedIUs();
        if (this.profileId == null || ius.length == 0) {
            ProvUI.reportStatus(this.getNoProfileOrSelectionStatus(this.profileId, ius), 4);
            this.runCanceled();
            return;
        }
        this.run(ius, this.profileId);
    }

    public IProfile getProfile() {
        String id = this.profileId == null ? this.ui.getProfileId() : this.profileId;
        return this.ui.getSession().getProfileRegistry().getProfile(id);
    }

    protected IStatus getNoProfileOrSelectionStatus(String id, IInstallableUnit[] ius) {
        return new Status(2, "org.eclipse.equinox.p2.ui", NLS.bind((String)ProvUIMessages.ProfileModificationAction_InvalidSelections, (Object)id, (Object)new Integer(ius.length)));
    }

    protected abstract ProfileChangeOperation getProfileChangeOperation(IInstallableUnit[] var1);

    protected void run(final IInstallableUnit[] ius, String id) {
        final ProfileChangeOperation operation = this.getProfileChangeOperation(ius);
        ProvisioningJob job = operation.getResolveJob(null);
        if (job == null) {
            ProvUI.reportStatus(operation.getResolutionResult(), 2);
        } else {
            job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (PlatformUI.isWorkbenchRunning()) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                if (ProfileModificationAction.this.validateOperation(operation)) {
                                    ProfileModificationAction.this.performAction(operation, ius);
                                }
                                (this).ProfileModificationAction.this.userChosenProfileId = null;
                            }
                        });
                    }
                }
            });
            this.getProvisioningUI().schedule(job, 3);
        }
        this.result = 0;
    }

    public int getReturnCode() {
        return this.result;
    }

    protected boolean validateOperation(ProfileChangeOperation operation) {
        if (operation != null) {
            return this.getPolicy().continueWorkingWithOperation(operation, this.getShell());
        }
        return false;
    }

    protected abstract int performAction(ProfileChangeOperation var1, IInstallableUnit[] var2);

    protected IInstallableUnit getIU(Object element) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (IInstallableUnit)ProvUI.getAdapter(element, clazz);
    }

    protected IInstallableUnit[] getSelectedIUs() {
        List elements = this.getStructuredSelection().toList();
        ArrayList<IInstallableUnit> iusList = new ArrayList<IInstallableUnit>(elements.size());
        int i = 0;
        while (i < elements.size()) {
            if (elements.get(i) instanceof IIUElement) {
                IIUElement element = (IIUElement)elements.get(i);
                if (this.isSelectable(element)) {
                    iusList.add(this.getIU(element));
                }
            } else {
                Class<?> clazz;
                try {
                    clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
                IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter(elements.get(i), clazz);
                if (iu != null && this.isSelectable(iu)) {
                    iusList.add(iu);
                }
            }
            ++i;
        }
        return iusList.toArray(new IInstallableUnit[iusList.size()]);
    }

    protected boolean isSelectable(IIUElement element) {
        return !(element instanceof CategoryElement);
    }

    protected boolean isSelectable(IInstallableUnit iu) {
        return !ProvUI.isCategory(iu);
    }

    protected LicenseManager getLicenseManager() {
        return this.getProvisioningUI().getLicenseManager();
    }

    protected QueryProvider getQueryProvider() {
        return ProvUI.getQueryProvider();
    }

    protected final void checkEnablement(Object[] selections) {
        if (this.isEnabledFor(selections)) {
            this.setEnabled(!this.getProvisioningUI().hasScheduledOperations());
        } else {
            this.setEnabled(false);
        }
    }

    protected abstract boolean isEnabledFor(Object[] var1);

    protected int getLock(IProfile profile, IInstallableUnit iu) {
        if (profile == null) {
            return 0;
        }
        try {
            String value = profile.getInstallableUnitProperty(iu, "org.eclipse.equinox.p2.type.lock");
            if (value != null) {
                return Integer.parseInt(value);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return 0;
    }

    protected String getProfileProperty(IProfile profile, IInstallableUnit iu, String propertyName) {
        if (profile == null || iu == null) {
            return null;
        }
        return profile.getInstallableUnitProperty(iu, propertyName);
    }

    private void runCanceled() {
        this.userChosenProfileId = null;
        this.result = 1;
    }
}

