/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.repository.IRepository;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AvailableIUElement
extends QueriedElement
implements IIUElement {
    IInstallableUnit iu;
    boolean shouldShowChildren;
    boolean isInstalled = false;
    boolean isUpdate = false;
    private static boolean shouldShowSize = false;
    long size = -1L;
    String profileID;

    public AvailableIUElement(Object parent, IInstallableUnit iu, String profileID, boolean showChildren) {
        super(parent);
        this.iu = iu;
        this.profileID = profileID;
        this.shouldShowChildren = showChildren;
    }

    @Override
    protected String getImageId(Object obj) {
        if (this.isUpdate) {
            return "obj/iu_update_obj.gif";
        }
        if (this.isInstalled) {
            return "obj/iu_disabled_obj.gif";
        }
        return "obj/iu_obj.gif";
    }

    @Override
    public String getLabel(Object o) {
        return this.iu.getId();
    }

    @Override
    public Object getAdapter(Class adapter) {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        if (adapter == clazz) {
            return this.iu;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void computeSize(IProgressMonitor monitor) {
        if (this.profileID == null) {
            return;
        }
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IProvisioningPlan plan = this.getSizingPlan((IProgressMonitor)mon.newChild(50));
        this.size = this.getProvisioningUI().getSession().getSize(plan, this.getProvisioningContext(), (IProgressMonitor)mon.newChild(50));
    }

    protected IProfile getProfile() {
        return this.getProvisioningUI().getSession().getProfileRegistry().getProfile(this.profileID);
    }

    protected IProvisioningPlan getSizingPlan(IProgressMonitor monitor) {
        ProfileChangeRequest request = ProfileChangeRequest.createByProfileId((String)this.profileID);
        request.addInstallableUnits(new IInstallableUnit[]{this.getIU()});
        return this.getProvisioningUI().getSession().getPlanner().getProvisioningPlan(request, this.getProvisioningContext(), monitor);
    }

    @Override
    public IInstallableUnit getIU() {
        return this.iu;
    }

    @Override
    public boolean shouldShowSize() {
        return shouldShowSize;
    }

    @Override
    public boolean shouldShowVersion() {
        return true;
    }

    @Override
    protected int getDefaultQueryType() {
        return 4;
    }

    @Override
    public Collection<IRequirement> getRequirements() {
        return this.iu.getRequiredCapabilities();
    }

    @Override
    public boolean shouldShowChildren() {
        return this.shouldShowChildren;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AvailableIUElement)) {
            return false;
        }
        if (this.iu == null) {
            return false;
        }
        return this.iu.equals((Object)((AvailableIUElement)obj).getIU());
    }

    public int hashCode() {
        if (this.iu == null) {
            return 0;
        }
        return this.iu.hashCode();
    }

    public String toString() {
        if (this.iu == null) {
            return "NULL";
        }
        return this.iu.toString();
    }

    public void setIsInstalled(boolean isInstalled) {
        this.isInstalled = isInstalled;
    }

    public boolean isInstalled() {
        return this.isInstalled;
    }

    public void setIsUpdate(boolean isUpdate) {
        this.isUpdate = isUpdate;
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    private ProvisioningContext getProvisioningContext() {
        if (this.hasQueryable() && this.getQueryable() instanceof IRepository) {
            return new ProvisioningContext(new URI[]{((IRepository)this.getQueryable()).getLocation()});
        }
        return new ProvisioningContext();
    }
}

