/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.IIUElement;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.swt.widgets.Shell;

public class ElementUtils {
    public static void updateRepositoryUsingElements(final MetadataRepositoryElement[] elements, Shell shell) {
        Job job = new Job(ProvUIMessages.ElementUtils_UpdateJobTitle){

            public IStatus run(IProgressMonitor monitor) {
                ProvisioningUI ui = ProvUIActivator.getDefault().getProvisioningUI();
                ui.signalRepositoryOperationStart();
                IMetadataRepositoryManager metaManager = ui.getSession().getMetadataRepositoryManager();
                IArtifactRepositoryManager artManager = ui.getSession().getArtifactRepositoryManager();
                try {
                    int visibilityFlags = ui.getRepositoryTracker().getMetadataRepositoryFlags();
                    URI[] currentlyEnabled = metaManager.getKnownRepositories(visibilityFlags);
                    URI[] currentlyDisabled = metaManager.getKnownRepositories(8 | visibilityFlags);
                    int i = 0;
                    while (i < elements.length) {
                        URI location = elements[i].getLocation();
                        if (elements[i].isEnabled()) {
                            if (ElementUtils.containsURI(currentlyDisabled, location)) {
                                ElementUtils.setColocatedRepositoryEnablement(ui, location, true);
                            } else if (!ElementUtils.containsURI(currentlyEnabled, location)) {
                                metaManager.addRepository(location);
                                artManager.addRepository(location);
                            }
                        } else if (ElementUtils.containsURI(currentlyEnabled, location)) {
                            ElementUtils.setColocatedRepositoryEnablement(ui, location, false);
                        } else if (!ElementUtils.containsURI(currentlyDisabled, location)) {
                            metaManager.addRepository(location);
                            artManager.addRepository(location);
                            ElementUtils.setColocatedRepositoryEnablement(ui, location, false);
                        }
                        String name = elements[i].getName();
                        if (name != null && name.length() > 0) {
                            metaManager.setRepositoryProperty(location, "p2.nickname", name);
                            artManager.setRepositoryProperty(location, "p2.nickname", name);
                        }
                        ++i;
                    }
                    HashSet<String> nowKnown = new HashSet<String>();
                    int i2 = 0;
                    while (i2 < elements.length) {
                        nowKnown.add(URIUtil.toUnencodedString((URI)elements[i2].getLocation()));
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < currentlyEnabled.length) {
                        if (!nowKnown.contains(URIUtil.toUnencodedString((URI)currentlyEnabled[i2]))) {
                            metaManager.removeRepository(currentlyEnabled[i2]);
                            artManager.removeRepository(currentlyEnabled[i2]);
                        }
                        ++i2;
                    }
                    i2 = 0;
                    while (i2 < currentlyDisabled.length) {
                        if (!nowKnown.contains(URIUtil.toUnencodedString((URI)currentlyDisabled[i2]))) {
                            metaManager.removeRepository(currentlyDisabled[i2]);
                            artManager.removeRepository(currentlyDisabled[i2]);
                        }
                        ++i2;
                    }
                }
                finally {
                    ui.signalRepositoryOperationComplete(null, true);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private static void setColocatedRepositoryEnablement(ProvisioningUI ui, URI location, boolean enable) {
        ProvUIActivator.getDefault().getSession().getArtifactRepositoryManager().setEnabled(location, enable);
        ProvUIActivator.getDefault().getSession().getMetadataRepositoryManager().setEnabled(location, enable);
    }

    public static IInstallableUnit getIU(Object element) {
        Class<?> clazz;
        if (element instanceof IInstallableUnit) {
            return (IInstallableUnit)element;
        }
        if (element instanceof IIUElement) {
            return ((IIUElement)element).getIU();
        }
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (IInstallableUnit)ProvUI.getAdapter(element, clazz);
    }

    public static IInstallableUnit[] elementsToIUs(Object[] elements) {
        ArrayList<IInstallableUnit> theIUs = new ArrayList<IInstallableUnit>(elements.length);
        int i = 0;
        while (i < elements.length) {
            Class<?> clazz;
            try {
                clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            IInstallableUnit iu = (IInstallableUnit)ProvUI.getAdapter(elements[i], clazz);
            if (iu != null) {
                theIUs.add(iu);
            }
            ++i;
        }
        return theIUs.toArray(new IInstallableUnit[theIUs.size()]);
    }

    static boolean containsURI(URI[] locations, URI url) {
        int i = 0;
        while (i < locations.length) {
            if (locations[i].equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

