/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.viewers;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.ProvElement;
import org.eclipse.jface.viewers.AbstractTableViewer;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.IDeferredWorkbenchAdapter;
import org.eclipse.ui.progress.IElementCollector;
import org.eclipse.ui.progress.PendingUpdateAdapter;

public class ProvElementContentProvider
implements ITreeContentProvider {
    private Viewer viewer;
    private Job fetchJob;
    Object fetchFamily = new Object();

    public Object[] getElements(final Object input) {
        if (input instanceof IDeferredWorkbenchAdapter && this.viewer instanceof AbstractTableViewer) {
            final Display display = this.viewer.getControl().getDisplay();
            final PendingUpdateAdapter pending = new PendingUpdateAdapter();
            if (this.fetchJob != null) {
                this.fetchJob.cancel();
            }
            this.fetchJob = new Job(ProvUIMessages.ProvElementContentProvider_FetchJobTitle){

                protected IStatus run(IProgressMonitor monitor) {
                    IDeferredWorkbenchAdapter parent = (IDeferredWorkbenchAdapter)input;
                    final ArrayList children = new ArrayList();
                    parent.fetchDeferredChildren((Object)parent, new IElementCollector(){

                        public void add(Object element, IProgressMonitor mon) {
                            if (mon.isCanceled()) {
                                return;
                            }
                            children.add(element);
                        }

                        public void add(Object[] elements, IProgressMonitor mon) {
                            if (mon.isCanceled()) {
                                return;
                            }
                            children.addAll(Arrays.asList(elements));
                        }

                        public void done() {
                        }
                    }, monitor);
                    display.asyncExec(new Runnable(){

                        public void run() {
                            AbstractTableViewer tableViewer = (AbstractTableViewer)ProvElementContentProvider.this.viewer;
                            if (ProvElementContentProvider.this.viewer == null || ProvElementContentProvider.this.viewer.getControl().isDisposed()) {
                                return;
                            }
                            tableViewer.getControl().setRedraw(false);
                            tableViewer.remove(pending);
                            tableViewer.add(children.toArray());
                            ProvElementContentProvider.this.finishedFetchingElements(input);
                            tableViewer.getControl().setRedraw(true);
                        }
                    });
                    return Status.OK_STATUS;
                }

                public boolean belongsTo(Object family) {
                    return family == ProvElementContentProvider.this.fetchFamily;
                }
            };
            this.fetchJob.schedule();
            return new Object[]{pending};
        }
        Object[] elements = this.getChildren(input);
        this.finishedFetchingElements(input);
        return elements;
    }

    public Object getParent(Object child) {
        if (child instanceof ProvElement) {
            return ((ProvElement)child).getParent(child);
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element instanceof ProvElement) {
            return ((ProvElement)element).hasChildren(element);
        }
        return false;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof ProvElement) {
            return ((ProvElement)parent).getChildren(parent);
        }
        return new Object[0];
    }

    public void dispose() {
        this.viewer = null;
        if (this.fetchJob != null) {
            this.fetchJob.cancel();
            this.fetchJob = null;
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = viewer;
        if (this.fetchJob != null) {
            this.fetchJob.cancel();
            this.fetchJob = null;
        }
    }

    protected void finishedFetchingElements(Object parent) {
    }
}

