/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ui;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.UpdateManagerCompatibility;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.query.GroupQuery;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.statushandlers.StatusManager;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Policy {
    public static final int RESTART_POLICY_FORCE = 1;
    public static final int RESTART_POLICY_FORCE_APPLY = 2;
    public static final int RESTART_POLICY_PROMPT = 3;
    public static final int RESTART_POLICY_PROMPT_RESTART_OR_APPLY = 4;
    private IQuery<IInstallableUnit> visibleAvailableIUQuery = new GroupQuery();
    private IQuery<IInstallableUnit> visibleInstalledIUQuery = new UserVisibleRootQuery();
    private boolean groupByCategory = true;
    private boolean allowDrilldown = true;
    private boolean repositoriesVisible = true;
    private boolean showLatestVersionsOnly = true;
    private int restartPolicy = 4;
    private String repoPrefPageId;
    private String repoPrefPageName;

    public boolean continueWorkingWithOperation(ProfileChangeOperation operation, Shell shell) {
        Assert.isTrue((boolean)operation.hasResolved());
        IStatus status = operation.getResolutionResult();
        if (status.getSeverity() == 8) {
            return false;
        }
        if (status.getCode() == 10000) {
            ProvUI.reportStatus(status, 4);
            return false;
        }
        if (operation.getProvisioningPlan() == null && !status.isOK()) {
            StatusManager.getManager().handle(status, 3);
            return false;
        }
        if (UpdateManagerCompatibility.requiresInstallHandlerSupport(operation.getProvisioningPlan())) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Shell shell = ProvUI.getDefaultParentShell();
                    MessageDialog dialog = new MessageDialog(shell, ProvUIMessages.Policy_RequiresUpdateManagerTitle, null, ProvUIMessages.Policy_RequiresUpdateManagerMessage, 4, new String[]{ProvUIMessages.LaunchUpdateManagerButton, IDialogConstants.CANCEL_LABEL}, 0);
                    if (dialog.open() == 0) {
                        BusyIndicator.showWhile((Display)shell.getDisplay(), (Runnable)new Runnable(){

                            public void run() {
                                UpdateManagerCompatibility.openInstaller();
                            }
                        });
                    }
                }
            });
            return false;
        }
        return true;
    }

    public IStatus getNoProfileChosenStatus() {
        return null;
    }

    public IQuery<IInstallableUnit> getVisibleAvailableIUQuery() {
        return this.visibleAvailableIUQuery;
    }

    public void setVisibleAvailableIUQuery(IQuery<IInstallableUnit> query) {
        this.visibleAvailableIUQuery = query;
    }

    public IQuery<IInstallableUnit> getVisibleInstalledIUQuery() {
        return this.visibleInstalledIUQuery;
    }

    public void setVisibleInstalledIUQuery(IQuery<IInstallableUnit> query) {
        this.visibleInstalledIUQuery = query;
    }

    public int getRestartPolicy() {
        return this.restartPolicy;
    }

    public void setRestartPolicy(int restartPolicy) {
        this.restartPolicy = restartPolicy;
    }

    public boolean getRepositoriesVisible() {
        return this.repositoriesVisible;
    }

    public void setRepositoriesVisible(boolean visible) {
        this.repositoriesVisible = visible;
    }

    public boolean getShowLatestVersionsOnly() {
        return this.showLatestVersionsOnly;
    }

    public void setShowLatestVersionsOnly(boolean showLatest) {
        this.showLatestVersionsOnly = showLatest;
    }

    public boolean getShowDrilldownRequirements() {
        return this.allowDrilldown;
    }

    public void setShowDrilldownRequirements(boolean drilldown) {
        this.allowDrilldown = drilldown;
    }

    public boolean getGroupByCategory() {
        return this.groupByCategory;
    }

    public void setGroupByCategory(boolean group) {
        this.groupByCategory = group;
    }

    public String getRepositoryPreferencePageId() {
        return this.repoPrefPageId;
    }

    public void setRepositoryPreferencePageId(String id) {
        this.repoPrefPageId = id;
    }

    public String getRepositoryPreferencePageName() {
        return this.repoPrefPageName;
    }

    public void setRepositoryPreferencePageName(String name) {
        this.repoPrefPageName = name;
    }
}

