/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateScheduler;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdater;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.PreferenceInitializer;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.PackageAdmin;

public class AutomaticUpdatePlugin
extends AbstractUIPlugin {
    public static final String ICON_PATH = "$nl$/icons/";
    public static final String IMG_TOOL_UPDATE = "tool/update.gif";
    public static final String IMG_TOOL_UPDATE_PROBLEMS = "tool/update_problems.gif";
    public static final String IMG_TOOL_CLOSE = "tool/close.gif";
    public static final String IMG_TOOL_CLOSE_HOT = "tool/close_hot.gif";
    private static AutomaticUpdatePlugin plugin;
    private static BundleContext context;
    private static PackageAdmin packageAdmin;
    private static ServiceReference packageAdminRef;
    private AutomaticUpdateScheduler scheduler;
    private AutomaticUpdater updater;
    private ScopedPreferenceStore preferenceStore;
    private ProvisioningSession session;
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.ui.sdk.scheduler";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        packageAdmin = null;
        packageAdminRef = null;
    }

    public static BundleContext getContext() {
        return context;
    }

    public static Bundle getBundle(String symbolicName) {
        if (packageAdmin == null) {
            return null;
        }
        Bundle[] bundles = packageAdmin.getBundles(symbolicName, null);
        if (bundles == null) {
            return null;
        }
        int i = 0;
        while (i < bundles.length) {
            if ((bundles[i].getState() & 3) == 0) {
                return bundles[i];
            }
            ++i;
        }
        return null;
    }

    public static AutomaticUpdatePlugin getDefault() {
        return plugin;
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.osgi.service.packageadmin.PackageAdmin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        packageAdminRef = bundleContext.getServiceReference(clazz.getName());
        packageAdmin = (PackageAdmin)bundleContext.getService(packageAdminRef);
        this.startEarly("org.eclipse.equinox.p2.exemplarysetup");
        this.startEarly("org.eclipse.equinox.p2.updatechecker");
        BundleContext bundleContext2 = AutomaticUpdatePlugin.getContext();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.equinox.p2.core.IProvisioningAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        IProvisioningAgent agent = (IProvisioningAgent)ServiceHelper.getService((BundleContext)bundleContext2, (String)clazz2.getName());
        this.session = new ProvisioningSession(agent);
        PreferenceInitializer.migratePreferences();
    }

    private boolean startEarly(String bundleName) throws BundleException {
        Bundle bundle = AutomaticUpdatePlugin.getBundle(bundleName);
        if (bundle == null) {
            return false;
        }
        bundle.start(1);
        return true;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        if (this.scheduler != null) {
            this.scheduler.shutdown();
            this.scheduler = null;
        }
        if (this.updater != null) {
            this.updater.shutdown();
            this.updater = null;
        }
        packageAdmin = null;
        packageAdminRef = null;
        plugin = null;
        super.stop(bundleContext);
        context = null;
    }

    public AutomaticUpdateScheduler getScheduler() {
        if (this.scheduler == null) {
            this.scheduler = new AutomaticUpdateScheduler();
        }
        return this.scheduler;
    }

    public AutomaticUpdater getAutomaticUpdater() {
        if (this.updater == null) {
            this.updater = new AutomaticUpdater();
        }
        return this.updater;
    }

    void setScheduler(AutomaticUpdateScheduler scheduler) {
        this.scheduler = scheduler;
    }

    public IProvisioningEventBus getProvisioningEventBus() {
        ServiceReference busReference = context.getServiceReference(IProvisioningEventBus.SERVICE_NAME);
        if (busReference == null) {
            return null;
        }
        return (IProvisioningEventBus)context.getService(busReference);
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProfileScope("_SELF_"), PLUGIN_ID);
        }
        return this.preferenceStore;
    }

    public void savePreferences() {
        if (this.preferenceStore != null) {
            try {
                this.preferenceStore.save();
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, PLUGIN_ID, 0, AutomaticUpdateMessages.ErrorSavingPreferences, (Throwable)e), 3);
            }
        }
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.createImageDescriptor(IMG_TOOL_UPDATE, reg);
        this.createImageDescriptor(IMG_TOOL_UPDATE_PROBLEMS, reg);
        this.createImageDescriptor(IMG_TOOL_CLOSE, reg);
        this.createImageDescriptor(IMG_TOOL_CLOSE_HOT, reg);
    }

    private void createImageDescriptor(String id, ImageRegistry reg) {
        URL url = FileLocator.find((Bundle)this.getBundle(), (IPath)new Path(ICON_PATH + id), null);
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)url);
        reg.put(id, desc);
    }

    public ProvisioningSession getSession() {
        return this.session;
    }
}

