/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk.scheduler;

import com.ibm.icu.util.Calendar;
import com.ibm.icu.util.ULocale;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.metadata.query.IUPropertyQuery;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdateMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.scheduler.AutomaticUpdatePlugin;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateChecker;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.IUpdateListener;
import org.eclipse.equinox.internal.provisional.p2.updatechecker.UpdateEvent;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;

public class AutomaticUpdateScheduler
implements IStartup {
    public static final String P_DAY = "day";
    public static final String P_HOUR = "hour";
    public static final String[] DAYS;
    public static final String[] HOURS;
    private IUpdateListener listener = null;
    private IUpdateChecker checker = null;
    String profileId;

    static {
        HOURS = new String[]{AutomaticUpdateMessages.SchedulerStartup_1AM, AutomaticUpdateMessages.SchedulerStartup_2AM, AutomaticUpdateMessages.SchedulerStartup_3AM, AutomaticUpdateMessages.SchedulerStartup_4AM, AutomaticUpdateMessages.SchedulerStartup_5AM, AutomaticUpdateMessages.SchedulerStartup_6AM, AutomaticUpdateMessages.SchedulerStartup_7AM, AutomaticUpdateMessages.SchedulerStartup_8AM, AutomaticUpdateMessages.SchedulerStartup_9AM, AutomaticUpdateMessages.SchedulerStartup_10AM, AutomaticUpdateMessages.SchedulerStartup_11AM, AutomaticUpdateMessages.SchedulerStartup_12PM, AutomaticUpdateMessages.SchedulerStartup_1PM, AutomaticUpdateMessages.SchedulerStartup_2PM, AutomaticUpdateMessages.SchedulerStartup_3PM, AutomaticUpdateMessages.SchedulerStartup_4PM, AutomaticUpdateMessages.SchedulerStartup_5PM, AutomaticUpdateMessages.SchedulerStartup_6PM, AutomaticUpdateMessages.SchedulerStartup_7PM, AutomaticUpdateMessages.SchedulerStartup_8PM, AutomaticUpdateMessages.SchedulerStartup_9PM, AutomaticUpdateMessages.SchedulerStartup_10PM, AutomaticUpdateMessages.SchedulerStartup_11PM, AutomaticUpdateMessages.SchedulerStartup_12AM};
        Calendar calendar = Calendar.getInstance((ULocale)new ULocale(Platform.getNL()));
        String[] daysAsStrings = new String[]{AutomaticUpdateMessages.SchedulerStartup_day, AutomaticUpdateMessages.SchedulerStartup_Sunday, AutomaticUpdateMessages.SchedulerStartup_Monday, AutomaticUpdateMessages.SchedulerStartup_Tuesday, AutomaticUpdateMessages.SchedulerStartup_Wednesday, AutomaticUpdateMessages.SchedulerStartup_Thursday, AutomaticUpdateMessages.SchedulerStartup_Friday, AutomaticUpdateMessages.SchedulerStartup_Saturday};
        int firstDay = calendar.getFirstDayOfWeek();
        DAYS = new String[8];
        AutomaticUpdateScheduler.DAYS[0] = daysAsStrings[0];
        int countDays = 0;
        int i = firstDay;
        while (i <= 7) {
            AutomaticUpdateScheduler.DAYS[++countDays] = daysAsStrings[i];
            ++i;
        }
        i = 1;
        while (i < firstDay) {
            AutomaticUpdateScheduler.DAYS[++countDays] = daysAsStrings[i];
            ++i;
        }
    }

    public AutomaticUpdateScheduler() {
        AutomaticUpdatePlugin.getDefault().setScheduler(this);
        this.checker = (IUpdateChecker)ServiceHelper.getService((BundleContext)AutomaticUpdatePlugin.getContext(), (String)IUpdateChecker.SERVICE_NAME);
        if (this.checker == null) {
            Status status = new Status(4, "org.eclipse.equinox.p2.ui.sdk.scheduler", AutomaticUpdateMessages.AutomaticUpdateScheduler_UpdateNotInitialized);
            StatusManager.getManager().handle((IStatus)status, 1);
            return;
        }
        this.profileId = "_SELF_";
    }

    public void earlyStartup() {
        this.scheduleUpdate();
    }

    public void shutdown() {
        this.removeUpdateListener();
    }

    public void rescheduleUpdate() {
        this.removeUpdateListener();
        IPreferenceStore pref = AutomaticUpdatePlugin.getDefault().getPreferenceStore();
        String schedule = pref.getString("schedule");
        if (schedule.equals("on-startup")) {
            return;
        }
        this.scheduleUpdate();
    }

    private void scheduleUpdate() {
        if (this.profileId == null) {
            return;
        }
        IPreferenceStore pref = AutomaticUpdatePlugin.getDefault().getPreferenceStore();
        if (!pref.getBoolean("enabled")) {
            return;
        }
        String schedule = pref.getString("schedule");
        long delay = -1L;
        long poll = -1L;
        if (!schedule.equals("on-startup")) {
            delay = this.computeDelay(pref);
            poll = this.computePoll(pref);
        }
        this.listener = new IUpdateListener(){

            public void updatesAvailable(UpdateEvent event) {
                AutomaticUpdatePlugin.getDefault().getAutomaticUpdater().updatesAvailable(event);
            }
        };
        this.checker.addUpdateCheck(this.profileId, this.getProfileQuery(), delay, poll, this.listener);
    }

    private IQuery getProfileQuery() {
        return new IUProfilePropertyByIdQuery("org.eclipse.equinox.p2.type.root", Boolean.toString(true));
    }

    private int getDay(IPreferenceStore pref) {
        String day = pref.getString(P_DAY);
        int d = 0;
        while (d < DAYS.length) {
            if (DAYS[d].equals(day)) {
                switch (d) {
                    case 0: {
                        return -1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 3: {
                        return 4;
                    }
                    case 4: {
                        return 5;
                    }
                    case 5: {
                        return 6;
                    }
                    case 6: {
                        return 7;
                    }
                    case 7: {
                        return 1;
                    }
                }
            }
            ++d;
        }
        return -1;
    }

    private int getHour(IPreferenceStore pref) {
        String hour = pref.getString(P_HOUR);
        int h = 0;
        while (h < HOURS.length) {
            if (HOURS[h].equals(hour)) {
                return h + 1;
            }
            ++h;
        }
        return 1;
    }

    private long computeDelay(IPreferenceStore pref) {
        int target_d = this.getDay(pref);
        int target_h = this.getHour(pref);
        Calendar calendar = Calendar.getInstance();
        int current_d = calendar.get(7);
        int current_h = calendar.get(11);
        int current_m = calendar.get(12);
        int current_s = calendar.get(13);
        int current_ms = calendar.get(14);
        long delay = 0L;
        if (target_d == -1) {
            if (target_h == current_h && current_m == 0 && current_s == 0) {
                return delay;
            }
            int delta_h = target_h - current_h;
            if (target_h <= current_h) {
                delta_h += 24;
            }
            delay = ((delta_h * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
            return delay;
        }
        if (target_d == current_d && target_h == current_h && current_m == 0 && current_s == 0) {
            return delay;
        }
        int delta_d = target_d - current_d;
        if (target_d < current_d || target_d == current_d && (target_h < current_h || target_h == current_h && current_m > 0)) {
            delta_d += 7;
        }
        delay = (((delta_d * 24 + target_h - current_h) * 60 - current_m) * 60 - current_s) * 1000 - current_ms;
        return delay;
    }

    private long computePoll(IPreferenceStore pref) {
        int target_d = this.getDay(pref);
        if (target_d == -1) {
            return 86400000L;
        }
        return 604800000L;
    }

    private void removeUpdateListener() {
        if (this.listener != null && this.checker != null) {
            this.checker.removeUpdateCheck(this.listener);
            this.listener = null;
        }
    }

    private class IUProfilePropertyByIdQuery
    extends IUPropertyQuery {
        private IProfile cachedProfile;

        public IUProfilePropertyByIdQuery(String propertyName, String propertyValue) {
            super(propertyName, propertyValue);
        }

        protected String getProperty(IInstallableUnit iu, String name) {
            IProfile profile = this.getProfile();
            if (profile == null) {
                return null;
            }
            return profile.getInstallableUnitProperty(iu, name);
        }

        private IProfile getProfile() {
            IProfileRegistry profileRegistry;
            if (this.cachedProfile == null && (profileRegistry = (IProfileRegistry)ServiceHelper.getService((BundleContext)AutomaticUpdatePlugin.getContext(), (String)IProfileRegistry.SERVICE_NAME)) != null) {
                this.cachedProfile = profileRegistry.getProfile(AutomaticUpdateScheduler.this.profileId);
            }
            return this.cachedProfile;
        }

        public void postPerform() {
            this.cachedProfile = null;
        }
    }
}

