/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.lnf.renderer;

import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.lnf.renderer.AbstractTitleBarRenderer;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ShellRenderer
extends AbstractTitleBarRenderer {
    private static final int TITLE_MARGIN = 5;
    private String[] btnImageKeys = new String[]{"TitlelessShell.closeIcon", "TitlelessShell.maxIcon", "TitlelessShell.minIcon", "TitlelessShell.restoreIcon"};
    private String[] btnHoverSelectedImageKeys = new String[]{"TitlelessShell.closeHoverSelectedIcon", "TitlelessShell.maxHoverSelectedIcon", "TitlelessShell.minHoverSelectedIcon", "TitlelessShell.restoreHoverIcon"};
    private String[] btnHoverImageKeys = new String[]{"TitlelessShell.closeHoverIcon", "TitlelessShell.maxHoverIcon", "TitlelessShell.minHoverIcon", "TitlelessShell.restoreHoverSelectedIcon"};
    private String[] btnInactiveImageKeys = new String[]{"TitlelessShell.closeInactiveIcon", "TitlelessShell.maxInactiveIcon", "TitlelessShell.minInactiveIcon", "TitlelessShell.restoreInactiveIcon"};

    protected void paintButton(GC gc, int btnIndex) {
        if (!LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue()) {
            return;
        }
        super.paintButton(gc, btnIndex);
    }

    protected Rectangle paintTitle(GC gc) {
        if (!LnfManager.getLnf().getBooleanSetting("Shell.hideOsBorder").booleanValue()) {
            return new Rectangle(0, 0, 0, 0);
        }
        String title = this.getShell().getText();
        if (StringUtils.isEmpty((CharSequence)title)) {
            return new Rectangle(0, 0, 0, 0);
        }
        Color fgColor = LnfManager.getLnf().getColor("TitlelessShell.foreground");
        if (!this.isActive()) {
            fgColor = LnfManager.getLnf().getColor("TitlelessShell.passiveForeground");
        }
        if (fgColor == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        gc.setForeground(fgColor);
        Font font = LnfManager.getLnf().getFont("TitlelessShell.font");
        gc.setFont(font);
        int textHeight = gc.getFontMetrics().getHeight();
        int y = this.getBounds().height / 2 - textHeight / 2;
        y -= 2;
        int x = this.getBounds().x + this.getBounds().width;
        int i = 0;
        while (i < this.getButtonsBounds().length) {
            if (this.getButtonsBounds()[i].x > 0) {
                x = Math.min(x, this.getButtonsBounds()[i].x);
            }
            ++i;
        }
        int textWidth = SwtUtilities.calcTextWidth((GC)gc, (String)title);
        switch (this.getHorizontalLogoPosition()) {
            case 16384: {
                x = 5;
                break;
            }
            case 0x1000000: {
                x = this.getBounds().width / 2 - textWidth / 2;
                break;
            }
            default: {
                x -= 5;
                x -= textWidth;
            }
        }
        gc.drawText(title, x, y, true);
        return new Rectangle(x, y, textWidth, textHeight);
    }

    protected Rectangle paintImage(GC gc) {
        return new Rectangle(0, 0, 0, 0);
    }

    private int getHorizontalLogoPosition() {
        Integer hPos = LnfManager.getLnf().getIntegerSetting("TitlelessShell.horizontalTextPosition");
        if (hPos == null) {
            hPos = 16384;
        }
        return hPos;
    }

    private Image getBackgroundImage() {
        return LnfManager.getLnf().getImage("TitlelessShell.backgroundImage");
    }

    protected String[] getBtnHoverImageKeys() {
        return this.btnHoverImageKeys;
    }

    protected String[] getBtnHoverSelectedImageKeys() {
        return this.btnHoverSelectedImageKeys;
    }

    protected String[] getBtnImageKeys() {
        return this.btnImageKeys;
    }

    protected String[] getBtnInactiveImageKeys() {
        return this.btnInactiveImageKeys;
    }

    protected void paintBackground(GC gc) {
    }
}

