/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.navigation.ui.swt.views;

import java.beans.Beans;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.equinox.log.Logger;
import org.eclipse.riena.core.IRienaActivator;
import org.eclipse.riena.core.Log4r;
import org.eclipse.riena.core.util.InvocationTargetFailure;
import org.eclipse.riena.core.util.StringUtils;
import org.eclipse.riena.internal.navigation.ui.swt.Activator;
import org.eclipse.riena.internal.navigation.ui.swt.handlers.NavigationSourceProvider;
import org.eclipse.riena.navigation.IApplicationNode;
import org.eclipse.riena.navigation.ISubModuleNode;
import org.eclipse.riena.navigation.NavigationNodeId;
import org.eclipse.riena.navigation.listener.ISubModuleNodeListener;
import org.eclipse.riena.navigation.listener.NavigationTreeObserver;
import org.eclipse.riena.navigation.listener.SubModuleNodeListener;
import org.eclipse.riena.navigation.model.SubModuleNode;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.navigation.ui.swt.presentation.SwtViewProvider;
import org.eclipse.riena.navigation.ui.swt.views.IComponentUpdateListener;
import org.eclipse.riena.navigation.ui.swt.views.INavigationNodeView;
import org.eclipse.riena.navigation.ui.swt.views.SWTModuleController;
import org.eclipse.riena.ui.common.IComplexComponent;
import org.eclipse.riena.ui.ridgets.controller.IController;
import org.eclipse.riena.ui.ridgets.swt.uibinding.AbstractViewBindingDelegate;
import org.eclipse.riena.ui.ridgets.swt.uibinding.DefaultSwtBindingDelegate;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.lnf.LnFUpdater;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.riena.ui.swt.utils.SWTBindingPropertyLocator;
import org.eclipse.riena.ui.swt.utils.SWTControlFinder;
import org.eclipse.riena.ui.swt.utils.SwtUtilities;
import org.eclipse.riena.ui.swt.utils.WidgetIdentificationSupport;
import org.eclipse.riena.ui.workarea.IWorkareaDefinition;
import org.eclipse.riena.ui.workarea.WorkareaManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.ViewPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SubModuleView<C extends SubModuleController>
extends ViewPart
implements INavigationNodeView<SWTModuleController, SubModuleNode> {
    private static final Logger LOGGER = Log4r.getLogger((IRienaActivator)Activator.getDefault(), SubModuleView.class);
    private static final LnFUpdater LNF_UPDATER = new LnFUpdater();
    private static final Map<SubModuleView<? extends SubModuleController>, SubModuleNode> FALLBACK_NODES = new HashMap<SubModuleView<? extends SubModuleController>, SubModuleNode>();
    private final AbstractViewBindingDelegate binding;
    private final FocusListener focusListener;
    private SubModuleController currentController;
    private SubModuleNode rcpSubModuleNode;
    private EmbeddedTitleBar title;
    private Composite parentComposite;
    private Composite contentComposite;
    private Map<Integer, Control> focusControlMap = new HashMap<Integer, Control>(1);
    private NavigationTreeObserver navigationTreeObserver;

    public SubModuleView() {
        this.binding = this.createBinding();
        this.focusListener = new FocusListener();
    }

    protected AbstractViewBindingDelegate createBinding() {
        return new DefaultSwtBindingDelegate();
    }

    protected void addUIControl(Object uiControl) {
        this.binding.addUIControl(uiControl);
    }

    protected void addUIControl(Object uiControl, String propertyName) {
        this.binding.addUIControl(uiControl, propertyName);
    }

    protected ISubModuleNode getSubModuleNode(String pId, String pSecondary) {
        return SwtViewProvider.getInstance().getNavigationNode(pId, pSecondary, ISubModuleNode.class);
    }

    public SubModuleController getController() {
        if (this.getNavigationNode() != null && this.getNavigationNode().getNavigationNodeController() instanceof SubModuleController) {
            return (SubModuleController)this.getNavigationNode().getNavigationNodeController();
        }
        return null;
    }

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        if (!Beans.isDesignTime()) {
            this.observeRoot();
            C controller = this.createController((ISubModuleNode)this.getNavigationNode());
            if (controller != null) {
                this.setPartName(((ISubModuleNode)controller.getNavigationNode()).getLabel());
            }
            this.contentComposite = this.createContentComposite(parent);
        } else {
            this.contentComposite = parent;
        }
        this.createWorkarea(this.contentComposite);
        LNF_UPDATER.updateUIControls(this.getParentComposite());
        if (!Beans.isDesignTime()) {
            this.createViewFacade();
            this.doBinding();
        }
        if (this.getViewSite() != null && this.getViewSite().getSecondaryId() != null) {
            WidgetIdentificationSupport.setIdentification((Widget)this.contentComposite, (String[])new String[]{"subModuleView", this.getViewSite().getId(), this.getViewSite().getSecondaryId()});
        }
        this.contentComposite.getDisplay().addFilter(15, (Listener)this.focusListener);
        this.contentComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                event.widget.getDisplay().removeFilter(15, (Listener)SubModuleView.this.focusListener);
            }
        });
    }

    protected void createWorkarea(Composite parent) {
        this.basicCreatePartControl(parent);
        this.afterBasicCreatePartControl(parent);
    }

    protected void afterBasicCreatePartControl(Composite parent) {
    }

    public void dispose() {
        IApplicationNode appNode = this.getAppNode();
        if (this.navigationTreeObserver != null && appNode != null) {
            this.navigationTreeObserver.removeListenerFrom(appNode);
        }
        FALLBACK_NODES.remove(this);
        super.dispose();
    }

    public void setFocus() {
        if (this.canRestoreFocus()) {
            Integer id = this.getControllerId();
            Control lastFocusedControl = this.focusControlMap.get(id);
            lastFocusedControl.setFocus();
        } else {
            this.contentComposite.setFocus();
        }
    }

    protected Composite getParentComposite() {
        return this.parentComposite;
    }

    protected Composite getContentComposite() {
        return this.contentComposite;
    }

    protected void blockView(boolean block) {
        if (!this.parentComposite.isDisposed()) {
            this.parentComposite.setCursor(block ? this.getWaitCursor() : this.getArrowCursor());
            this.contentComposite.setEnabled(!block);
        }
    }

    protected abstract void basicCreatePartControl(Composite var1);

    protected final boolean canRestoreFocus() {
        Integer id = this.getControllerId();
        Control control = this.focusControlMap.get(id);
        return !SwtUtilities.isDisposed((Widget)control);
    }

    protected void createViewFacade() {
        this.addUIControls(this.getParentComposite());
        if (this.getController() == null) {
            this.createController((ISubModuleNode)this.getNavigationNode());
        }
        if (this.getController() != null) {
            this.binding.injectRidgets((IController)this.getController());
        }
    }

    protected C createController(ISubModuleNode node) {
        Assert.isNotNull((Object)node, (String)"navigation node must not be null");
        Assert.isNotNull((Object)node.getNodeId(), (String)"navigation node id must not be null");
        Assert.isNotNull((Object)node.getNodeId().getTypeId(), (String)"navigation node type id must not be null");
        SubModuleController controller = null;
        IWorkareaDefinition def = WorkareaManager.getInstance().getDefinition((Object)node);
        if (def != null) {
            try {
                controller = (SubModuleController)def.createController();
            }
            catch (Exception ex) {
                String message = String.format("cannnot create controller for class %s", def.getControllerClass());
                LOGGER.log(1, message, (Throwable)ex);
                throw new InvocationTargetFailure(message, (Throwable)ex);
            }
        }
        if (controller != null) {
            controller.setNavigationNode(node);
        }
        return (C)controller;
    }

    @Override
    public void addUpdateListener(IComponentUpdateListener listener) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void bind(SubModuleNode node) {
        if (this.currentController != this.getController()) {
            if (this.currentController != null) {
                if (((ISubModuleNode)this.currentController.getNavigationNode()).isDisposed()) {
                    return;
                }
                this.binding.unbind((IController)this.currentController);
            }
            if (this.getNavigationNode() != null && this.getController() == null) {
                this.createViewFacade();
            }
            if (this.getController() != null) {
                this.currentController = this.getController();
            }
            this.binding.bind((IController)this.currentController);
            this.currentController.afterBind();
        }
        NavigationSourceProvider.activeNodeChanged(this.getNavigationNode());
        LNF_UPDATER.updateUIControlsAfterBind(this.getParentComposite());
    }

    @Override
    public SubModuleNode getNavigationNode() {
        String secondaryId;
        if (this.getViewSite() == null) {
            return this.getFallbackNavigationNode();
        }
        String viewId = this.getViewSite().getId();
        SubModuleNode result = (SubModuleNode)this.getSubModuleNode(viewId, secondaryId = this.getViewSite().getSecondaryId());
        if (result == null) {
            result = this.getRCPSubModuleNode();
        }
        if (result == null) {
            result = this.getFallbackNavigationNode();
        }
        return result;
    }

    @Override
    public void unbind() {
        SubModuleController controller = this.getController();
        if (controller != null) {
            this.binding.unbind((IController)controller);
        }
    }

    private void addUIControls(Composite composite) {
        SWTControlFinder finder = new SWTControlFinder(composite){

            public void handleBoundControl(Control control, String bindingProperty) {
                SubModuleView.this.addUIControl(control);
            }

            public void handleControl(Control control) {
                if (control.getMenu() != null) {
                    SubModuleView.this.addMenuControl(control.getMenu());
                }
                super.handleControl(control);
            }
        };
        finder.run();
    }

    private void addMenuControl(Menu menu) {
        SWTBindingPropertyLocator locator = SWTBindingPropertyLocator.getInstance();
        int i = 0;
        while (i < menu.getItemCount()) {
            MenuItem item = menu.getItem(i);
            String bindingId = locator.locateBindingProperty((Object)item);
            if (StringUtils.isGiven((CharSequence)bindingId)) {
                this.addUIControl(item, bindingId);
            }
            if (item.getMenu() != null) {
                this.addMenuControl(item.getMenu());
            }
            ++i;
        }
    }

    private Composite createContentComposite(Composite parent) {
        Color bgColor = LnfManager.getLnf().getColor("SubModule.background");
        parent.setBackground(bgColor);
        parent.setLayout((Layout)new FormLayout());
        if (!this.isRCP()) {
            this.title = new EmbeddedTitleBar(parent, 0);
            this.addUIControl(this.title, "windowRidget");
            this.title.setWindowActive(true);
            FormData formData = new FormData();
            formData.top = new FormAttachment(0, -1);
            formData.left = new FormAttachment(0, -1);
            formData.bottom = new FormAttachment(0, this.title.getSize().y - 1);
            formData.right = new FormAttachment(100, 2);
            this.title.setLayoutData((Object)formData);
        }
        Composite composite = new Composite(parent, 0x20000000);
        composite.setBackground(bgColor);
        FormData formData = new FormData();
        formData.top = this.title != null ? new FormAttachment((Control)this.title, 0, 0) : new FormAttachment(0, -1);
        formData.left = new FormAttachment(0, 0);
        formData.bottom = new FormAttachment(100);
        formData.right = new FormAttachment(100);
        composite.setLayoutData((Object)formData);
        return composite;
    }

    private void doBinding() {
        this.bind(this.getNavigationNode());
        if (this.title != null) {
            this.title.setWindowActive(this.getNavigationNode().isActivated());
        }
    }

    private Cursor getArrowCursor() {
        return this.contentComposite.getDisplay().getSystemCursor(0);
    }

    private IApplicationNode getAppNode() {
        SubModuleNode node = this.getNavigationNode();
        while (node.getParent() != null) {
            node = node.getParent();
        }
        IApplicationNode appNode = (IApplicationNode)node.getTypecastedAdapter(IApplicationNode.class);
        return appNode;
    }

    private int getControllerId() {
        SubModuleController controller = this.getController();
        return controller == null ? 0 : controller.hashCode();
    }

    private SubModuleNode getFallbackNavigationNode() {
        SubModuleNode fallbackNode = FALLBACK_NODES.get(this);
        if (fallbackNode == null) {
            fallbackNode = new SubModuleNode(new NavigationNodeId(String.valueOf(this.getClass().getName()) + FALLBACK_NODES.size()));
            FALLBACK_NODES.put(this, fallbackNode);
        }
        return fallbackNode;
    }

    private SubModuleNode getRCPSubModuleNode() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor("org.eclipse.riena.navigation.assemblies");
        String viewId = this.getViewSite().getId();
        return this.getRCPSubModuleNode(viewId, elements);
    }

    private SubModuleNode getRCPSubModuleNode(String viewId, IConfigurationElement[] elements) {
        int i = 0;
        while (this.rcpSubModuleNode == null && i < elements.length) {
            IConfigurationElement element = elements[i];
            if ("submodule".equals(element.getName())) {
                String typeId;
                String view = element.getAttribute("view");
                if (viewId.equals(view) && (typeId = element.getAttribute("typeId")) != null) {
                    this.rcpSubModuleNode = new SubModuleNode(new NavigationNodeId(typeId), this.getPartName());
                }
            } else if (element.getChildren().length > 0) {
                this.rcpSubModuleNode = this.getRCPSubModuleNode(viewId, element.getChildren());
            }
            ++i;
        }
        return this.rcpSubModuleNode;
    }

    private Cursor getWaitCursor() {
        return this.contentComposite.getDisplay().getSystemCursor(1);
    }

    private boolean isChildOfComplexComponent(Control uiControl) {
        if (uiControl.getParent() == null) {
            return false;
        }
        if (uiControl.getParent() instanceof IComplexComponent) {
            return true;
        }
        return this.isChildOfComplexComponent((Control)uiControl.getParent());
    }

    private boolean isRCP() {
        this.getNavigationNode();
        return this.rcpSubModuleNode != null;
    }

    private void observeRoot() {
        IApplicationNode appNode = this.getAppNode();
        if (appNode != null) {
            Assert.isLegal((this.navigationTreeObserver == null ? 1 : 0) != 0);
            this.navigationTreeObserver = new NavigationTreeObserver();
            this.navigationTreeObserver.addListener((ISubModuleNodeListener)new SubModuleNodesListener());
            this.navigationTreeObserver.addListenerTo(appNode);
        }
    }

    private final class FocusListener
    implements Listener {
        private FocusListener() {
        }

        public void handleEvent(Event event) {
            if (SubModuleView.this.contentComposite.isVisible() && event.widget instanceof Control) {
                int id;
                Control control = (Control)event.widget;
                if (this.contains(SubModuleView.this.contentComposite, control) && (id = SubModuleView.this.getControllerId()) != 0) {
                    SubModuleView.this.focusControlMap.put(id, control);
                }
            }
        }

        private boolean contains(Composite container, Control control) {
            boolean result = false;
            Composite parent = control.getParent();
            while (!result && parent != null) {
                result = container == parent;
                parent = parent.getParent();
            }
            return result;
        }
    }

    private final class SubModuleNodesListener
    extends SubModuleNodeListener {
        private SubModuleNodesListener() {
        }

        public void activated(ISubModuleNode source) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                SubModuleView.this.doBinding();
            }
        }

        public void block(ISubModuleNode source, boolean block) {
            if (source.equals(SubModuleView.this.getNavigationNode())) {
                SubModuleView.this.blockView(block);
            }
        }
    }
}

