/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.net.URI;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.provisional.p2.repository.RepositoryEvent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.ProvisioningUI;

public class ArtifactRepositoryTracker
extends RepositoryTracker {
    ProvisioningUI ui;

    public ArtifactRepositoryTracker(ProvisioningUI ui) {
        this.ui = ui;
    }

    public URI[] getKnownRepositories(ProvisioningSession session) {
        return session.getArtifactRepositoryManager().getKnownRepositories(this.getArtifactRepositoryFlags());
    }

    protected IStatus validateRepositoryLocationWithManager(ProvisioningSession session, URI location, IProgressMonitor monitor) {
        return Status.OK_STATUS;
    }

    public void addRepository(URI repoLocation, String nickname, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            session.getArtifactRepositoryManager().addRepository(repoLocation);
            if (nickname != null) {
                session.getArtifactRepositoryManager().setRepositoryProperty(repoLocation, "p2.nickname", nickname);
            }
        }
        finally {
            this.ui.signalRepositoryOperationComplete(new RepositoryEvent(repoLocation, 1, 0, true), true);
        }
    }

    public void removeRepositories(URI[] repoLocations, ProvisioningSession session) {
        this.ui.signalRepositoryOperationStart();
        try {
            int i = 0;
            while (i < repoLocations.length) {
                session.getArtifactRepositoryManager().removeRepository(repoLocations[i]);
                ++i;
            }
        }
        finally {
            this.ui.signalRepositoryOperationComplete(null, true);
        }
    }

    public void refreshRepositories(URI[] locations, ProvisioningSession session, IProgressMonitor monitor) {
        this.ui.signalRepositoryOperationStart();
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)(locations.length * 100));
        int i = 0;
        while (i < locations.length) {
            try {
                session.getArtifactRepositoryManager().refreshRepository(locations[i], (IProgressMonitor)mon.newChild(100));
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
        this.ui.signalRepositoryOperationComplete(null, true);
    }
}

