/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.admin;

import java.util.List;
import org.eclipse.equinox.internal.p2.ui.QueryableMetadataRepositoryManager;
import org.eclipse.equinox.internal.p2.ui.actions.InstallAction;
import org.eclipse.equinox.internal.p2.ui.admin.MetadataRepositoryTracker;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIActivator;
import org.eclipse.equinox.internal.p2.ui.admin.ProvAdminUIMessages;
import org.eclipse.equinox.internal.p2.ui.admin.RepositoriesView;
import org.eclipse.equinox.internal.p2.ui.admin.dialogs.AddMetadataRepositoryDialog;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.internal.p2.ui.viewers.IUDragAdapter;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.part.PluginTransfer;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataRepositoriesView
extends RepositoriesView {
    private InstallAction installAction;
    private RepositoryTracker tracker;
    MetadataRepositories input;

    @Override
    protected Object getInput() {
        if (this.input == null) {
            IUViewQueryContext context = new IUViewQueryContext(2);
            Policy policy = ProvAdminUIActivator.getDefault().getPolicy();
            context.setShowLatestVersionsOnly(policy.getShowLatestVersionsOnly());
            context.setShowInstallChildren(policy.getShowDrilldownRequirements());
            context.setShowProvisioningPlanChildren(policy.getShowDrilldownRequirements());
            context.setUseCategories(policy.getGroupByCategory());
            this.input = new MetadataRepositories(context, this.getProvisioningUI(), new QueryableMetadataRepositoryManager(this.getProvisioningUI(), false));
        }
        return this.input;
    }

    @Override
    protected String getAddCommandLabel() {
        return ProvAdminUIMessages.MetadataRepositoriesView_AddRepositoryLabel;
    }

    @Override
    protected String getAddCommandTooltip() {
        return ProvAdminUIMessages.MetadataRepositoriesView_AddRepositoryTooltip;
    }

    @Override
    protected String getRemoveCommandTooltip() {
        return ProvAdminUIMessages.MetadataRepositoriesView_RemoveRepositoryTooltip;
    }

    @Override
    protected int openAddRepositoryDialog(Shell shell) {
        return new AddMetadataRepositoryDialog(shell, this.getProvisioningUI()).open();
    }

    @Override
    protected void makeActions() {
        super.makeActions();
        this.installAction = new InstallAction(this.getProvisioningUI(), (ISelectionProvider)this.viewer, null);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        if (this.installAction.isEnabled()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.installAction);
        }
        super.fillContextMenu(manager);
    }

    @Override
    protected void configureViewer(TreeViewer treeViewer) {
        super.configureViewer(treeViewer);
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer(), PluginTransfer.getInstance(), TextTransfer.getInstance()};
        treeViewer.addDragSupport(1, transfers, (DragSourceListener)new IUDragAdapter((ISelectionProvider)treeViewer));
    }

    protected int getRepoFlags() {
        if (ProvAdminUIActivator.getDefault().getPreferenceStore().getBoolean("org.eclipse.equinox.internal.provisional.p2.ui.admin.hideSystemRepos")) {
            return 2;
        }
        return 0;
    }

    @Override
    protected int getListenerEventTypes() {
        return 1;
    }

    @Override
    protected List<String> getVisualProperties() {
        List<String> list = super.getVisualProperties();
        list.add("org.eclipse.equinox.internal.provisional.p2.ui.admin.useCategories");
        list.add("org.eclipse.equinox.internal.provisional.p2.ui.admin.collapseIUVersions");
        return list;
    }

    @Override
    protected RepositoryTracker getRepositoryTracker() {
        if (this.tracker == null) {
            this.tracker = new MetadataRepositoryTracker(this.getProvisioningUI());
        }
        return this.tracker;
    }
}

