/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal;

import java.io.IOException;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.internal.Activator;
import org.eclipse.equinox.http.servlet.internal.FilterChainImpl;
import org.eclipse.equinox.http.servlet.internal.FilterConfigImpl;
import org.eclipse.equinox.http.servlet.internal.FilterRegistration;
import org.eclipse.equinox.http.servlet.internal.HttpServletRequestAdaptor;
import org.eclipse.equinox.http.servlet.internal.ProxyContext;
import org.eclipse.equinox.http.servlet.internal.ResourceServlet;
import org.eclipse.equinox.http.servlet.internal.ServletConfigImpl;
import org.eclipse.equinox.http.servlet.internal.ServletContextAdaptor;
import org.eclipse.equinox.http.servlet.internal.ServletRegistration;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.NamespaceException;

public class ProxyServlet
extends HttpServlet {
    private static final long serialVersionUID = 4117456123807468871L;
    private Map servletRegistrations = new HashMap();
    private Set registeredServlets = new HashSet();
    private Map filterRegistrations = new HashMap();
    private ProxyContext proxyContext;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.proxyContext = new ProxyContext(config.getServletContext());
        Activator.addProxyServlet(this);
    }

    public void destroy() {
        Activator.removeProxyServlet(this);
        this.proxyContext.destroy();
        this.proxyContext = null;
        super.destroy();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.proxyContext.initializeServletPath(req);
        String alias = HttpServletRequestAdaptor.getDispatchPathInfo(req);
        if (alias == null) {
            alias = "/";
        }
        if (this.processAlias(req, resp, alias, null)) {
            return;
        }
        String extensionAlias = this.findExtensionAlias(alias);
        alias = alias.substring(0, alias.lastIndexOf(47));
        while (alias.length() != 0) {
            if (this.processAlias(req, resp, alias, extensionAlias)) {
                return;
            }
            alias = alias.substring(0, alias.lastIndexOf(47));
        }
        if (extensionAlias != null) {
            extensionAlias = extensionAlias.substring(1);
        }
        if (this.processAlias(req, resp, "/", extensionAlias)) {
            return;
        }
        resp.sendError(404, "ProxyServlet: " + req.getRequestURI());
    }

    private String findExtensionAlias(String alias) {
        String lastSegment = alias.substring(alias.lastIndexOf(47) + 1);
        int dot = lastSegment.indexOf(46);
        if (dot == -1) {
            return null;
        }
        String extension = lastSegment.substring(dot + 1);
        if (extension.length() == 0) {
            return null;
        }
        return "/*." + extension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean processAlias(HttpServletRequest req, HttpServletResponse resp, String alias, String extensionAlias) throws ServletException, IOException {
        registration = null;
        matchingFilterRegistrations = Collections.EMPTY_LIST;
        dispatchPathInfo = HttpServletRequestAdaptor.getDispatchPathInfo(req);
        var8_8 = this;
        synchronized (var8_8) {
            if (extensionAlias == null) {
                registration = (ServletRegistration)this.servletRegistrations.get(alias);
            } else {
                registration = (ServletRegistration)this.servletRegistrations.get(String.valueOf(alias) + extensionAlias);
                if (registration != null) {
                    if (!(registration.getServlet() instanceof ResourceServlet)) {
                        alias = HttpServletRequestAdaptor.getDispatchPathInfo(req);
                    }
                } else {
                    registration = (ServletRegistration)this.servletRegistrations.get(alias);
                }
            }
            if (registration != null) {
                registration.addReference();
                if (!this.filterRegistrations.isEmpty()) {
                    matchingFilterRegistrations = new ArrayList<FilterRegistration>();
                    it = this.filterRegistrations.values().iterator();
                    while (it.hasNext()) {
                        filterRegistration = (FilterRegistration)it.next();
                        if (!filterRegistration.matches(dispatchPathInfo)) continue;
                        matchingFilterRegistrations.add(filterRegistration);
                        filterRegistration.addReference();
                    }
                }
            }
        }
        if (registration != null) {
            try {
                wrappedRequest = new HttpServletRequestAdaptor(req, alias, registration.getServlet());
                if (matchingFilterRegistrations.isEmpty()) {
                    registration.service((HttpServletRequest)wrappedRequest, resp);
                }
                chain = new FilterChainImpl(matchingFilterRegistrations, registration);
                chain.doFilter((ServletRequest)wrappedRequest, (ServletResponse)resp);
            }
            finally {
                registration.removeReference();
                it = matchingFilterRegistrations.iterator();
                ** while (it.hasNext())
            }
lbl-1000:
            // 1 sources

            {
                filterRegistration = (FilterRegistration)it.next();
                filterRegistration.removeReference();
                continue;
            }
lbl47:
            // 1 sources

            return true;
        }
        return false;
    }

    synchronized void unregister(String alias, boolean destroy) {
        ServletRegistration removedRegistration = (ServletRegistration)this.servletRegistrations.remove(alias);
        if (removedRegistration != null) {
            this.registeredServlets.remove(removedRegistration.getServlet());
            try {
                if (destroy) {
                    removedRegistration.destroy();
                }
            }
            finally {
                this.proxyContext.destroyContextAttributes(removedRegistration.getHttpContext());
            }
        }
    }

    synchronized void registerServlet(String alias, Servlet servlet, Dictionary initparams, HttpContext httpContext) throws ServletException, NamespaceException {
        this.checkAlias(alias);
        if (this.servletRegistrations.containsKey(alias)) {
            throw new NamespaceException("The alias '" + alias + "' is already in use.");
        }
        if (servlet == null) {
            throw new IllegalArgumentException("Servlet cannot be null");
        }
        if (this.registeredServlets.contains(servlet)) {
            throw new ServletException("This servlet has already been registered.");
        }
        ServletRegistration registration = new ServletRegistration(servlet, httpContext);
        ServletContextAdaptor wrappedServletContext = new ServletContextAdaptor(this.proxyContext, this.getServletContext(), httpContext, AccessController.getContext());
        ServletConfigImpl servletConfig = new ServletConfigImpl(servlet, initparams, wrappedServletContext);
        boolean initialized = false;
        this.proxyContext.createContextAttributes(httpContext);
        try {
            registration.init(servletConfig);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.proxyContext.destroyContextAttributes(httpContext);
            }
        }
        this.registeredServlets.add(servlet);
        this.servletRegistrations.put(alias, registration);
    }

    synchronized void registerResources(String alias, String name, HttpContext httpContext) throws NamespaceException {
        this.checkName(name);
        ResourceServlet resourceServlet = new ResourceServlet(name, httpContext, AccessController.getContext());
        try {
            this.registerServlet(alias, (Servlet)resourceServlet, null, httpContext);
        }
        catch (ServletException servletException) {
            throw new IllegalStateException("Unexpected ServletException throw when registering resources at alias " + alias + ".");
        }
    }

    private void checkName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Name cannot be null");
        }
        if (name.endsWith("/") && !name.equals("/")) {
            throw new IllegalArgumentException("Invalid Name '" + name + "'");
        }
    }

    private void checkAlias(String alias) {
        if (alias == null) {
            throw new IllegalArgumentException("Alias cannot be null");
        }
        if (!alias.startsWith("/") || alias.endsWith("/") && !alias.equals("/")) {
            throw new IllegalArgumentException("Invalid alias '" + alias + "'");
        }
    }

    public synchronized void unregisterFilter(Filter filter, boolean destroy) {
        FilterRegistration removedRegistration = (FilterRegistration)this.filterRegistrations.remove(filter);
        if (removedRegistration != null) {
            try {
                if (destroy) {
                    removedRegistration.destroy();
                }
            }
            finally {
                this.proxyContext.destroyContextAttributes(removedRegistration.getHttpContext());
            }
        }
    }

    public synchronized void registerFilter(String alias, Filter filter, Dictionary initparams, HttpContext httpContext) throws ServletException {
        this.checkAlias(alias);
        if (filter == null) {
            throw new IllegalArgumentException("Filter cannot be null");
        }
        if (this.filterRegistrations.containsKey(filter)) {
            throw new ServletException("This filter has already been registered.");
        }
        FilterRegistration registration = new FilterRegistration(filter, httpContext, alias);
        ServletContextAdaptor wrappedServletContext = new ServletContextAdaptor(this.proxyContext, this.getServletContext(), httpContext, AccessController.getContext());
        FilterConfigImpl filterConfig = new FilterConfigImpl(filter, initparams, wrappedServletContext);
        boolean initialized = false;
        this.proxyContext.createContextAttributes(httpContext);
        try {
            registration.init(filterConfig);
            initialized = true;
        }
        finally {
            if (!initialized) {
                this.proxyContext.destroyContextAttributes(httpContext);
            }
        }
        this.filterRegistrations.put(filter, registration);
    }
}

