/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.engine;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.engine.Messages;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;

public class DownloadManager {
    private ProvisioningContext provContext = null;
    ArrayList<IArtifactRequest> requestsToProcess = new ArrayList();
    private static final String FILE_PROTOCOL = "file";
    private static final Comparator<URI> LOCAL_FIRST_COMPARATOR = new Comparator<URI>(){

        @Override
        public int compare(URI arg0, URI arg1) {
            String protocol0 = arg0.getScheme();
            String protocol1 = arg1.getScheme();
            if (DownloadManager.FILE_PROTOCOL.equals(protocol0) && !DownloadManager.FILE_PROTOCOL.equals(protocol1)) {
                return -1;
            }
            if (!DownloadManager.FILE_PROTOCOL.equals(protocol0) && DownloadManager.FILE_PROTOCOL.equals(protocol1)) {
                return 1;
            }
            return 0;
        }
    };
    private final IArtifactRepositoryManager repositoryManager;

    public DownloadManager(ProvisioningContext context, IArtifactRepositoryManager repositoryManager) {
        this.provContext = context;
        this.repositoryManager = repositoryManager;
    }

    public void add(IArtifactRequest toAdd) {
        Assert.isNotNull((Object)toAdd);
        this.requestsToProcess.add(toAdd);
    }

    public void add(IArtifactRequest[] toAdd) {
        Assert.isNotNull((Object)toAdd);
        int i = 0;
        while (i < toAdd.length) {
            this.add(toAdd[i]);
            ++i;
        }
    }

    private void filterUnfetched() {
        Iterator<IArtifactRequest> iterator = this.requestsToProcess.iterator();
        while (iterator.hasNext()) {
            IArtifactRequest request = iterator.next();
            if (request.getResult() == null || !request.getResult().isOK()) continue;
            iterator.remove();
        }
    }

    public IStatus start(IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.download_artifact, (int)this.requestsToProcess.size());
        try {
            if (this.requestsToProcess.isEmpty()) {
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            URI[] repositories = null;
            repositories = this.provContext == null || this.provContext.getArtifactRepositories() == null ? this.repositoryManager.getKnownRepositories(0) : this.provContext.getArtifactRepositories();
            if (repositories.length == 0) {
                Status status = new Status(4, "org.eclipse.equinox.p2.engine", Messages.download_no_repository, (Throwable)new Exception());
                return status;
            }
            Arrays.sort(repositories, LOCAL_FIRST_COMPARATOR);
            this.fetch(repositories, subMonitor);
            IStatus iStatus = this.overallStatus(monitor);
            return iStatus;
        }
        finally {
            subMonitor.done();
        }
    }

    private void fetch(URI[] repositories, SubMonitor monitor) {
        int i = 0;
        while (i < repositories.length && !this.requestsToProcess.isEmpty() && !monitor.isCanceled()) {
            try {
                IArtifactRepository current = this.repositoryManager.loadRepository(repositories[i], (IProgressMonitor)monitor.newChild(0));
                IArtifactRequest[] requests = this.getRequestsForRepository(current);
                IStatus dlStatus = current.getArtifacts(requests, (IProgressMonitor)monitor.newChild(requests.length));
                if (dlStatus.getSeverity() == 8) {
                    return;
                }
                this.filterUnfetched();
                monitor.setWorkRemaining(this.requestsToProcess.size());
            }
            catch (ProvisionException provisionException) {}
            ++i;
        }
    }

    private IArtifactRequest[] getRequestsForRepository(IArtifactRepository repository) {
        ArrayList<IArtifactRequest> applicable = new ArrayList<IArtifactRequest>();
        Iterator<IArtifactRequest> iterator = this.requestsToProcess.iterator();
        while (iterator.hasNext()) {
            IArtifactRequest request = iterator.next();
            if (!repository.contains(request.getArtifactKey())) continue;
            applicable.add(request);
        }
        return applicable.toArray(new IArtifactRequest[applicable.size()]);
    }

    private IStatus overallStatus(IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return Status.CANCEL_STATUS;
        }
        if (this.requestsToProcess.size() == 0) {
            return Status.OK_STATUS;
        }
        MultiStatus result = new MultiStatus("org.eclipse.equinox.p2.engine", 0, null, null);
        Iterator<IArtifactRequest> iterator = this.requestsToProcess.iterator();
        while (iterator.hasNext()) {
            IArtifactRequest request = iterator.next();
            IStatus failed = request.getResult();
            if (failed == null || failed.isOK()) continue;
            result.add(failed);
        }
        return result;
    }
}

