/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.engine;

import java.util.ArrayList;
import org.eclipse.equinox.internal.p2.engine.EngineActivator;
import org.eclipse.equinox.internal.p2.engine.Phase;
import org.eclipse.equinox.internal.p2.engine.PhaseSet;
import org.eclipse.equinox.internal.p2.engine.phases.CheckTrust;
import org.eclipse.equinox.internal.p2.engine.phases.Collect;
import org.eclipse.equinox.internal.p2.engine.phases.Configure;
import org.eclipse.equinox.internal.p2.engine.phases.Install;
import org.eclipse.equinox.internal.p2.engine.phases.Property;
import org.eclipse.equinox.internal.p2.engine.phases.Unconfigure;
import org.eclipse.equinox.internal.p2.engine.phases.Uninstall;

public class DefaultPhaseSet
extends PhaseSet {
    private static final boolean forcedUninstall = Boolean.valueOf(EngineActivator.getContext().getProperty("org.eclipse.equinox.p2.engine.forcedUninstall"));
    public static int PHASE_COLLECT = 2;
    public static int PHASE_UNCONFIGURE = 32;
    public static int PHASE_UNINSTALL = 64;
    public static int PHASE_PROPERTY = 16;
    public static int PHASE_CHECK_TRUST = 1;
    public static int PHASE_INSTALL = 8;
    public static int PHASE_CONFIGURE = 4;

    public DefaultPhaseSet() {
        this(new Phase[]{new Collect(100), new Unconfigure(10, forcedUninstall), new Uninstall(50, forcedUninstall), new Property(1), new CheckTrust(10), new Install(50), new Configure(10)});
    }

    private DefaultPhaseSet(Phase[] phases) {
        super(phases);
    }

    public static final PhaseSet createDefaultPhaseSet(int exclude) {
        ArrayList<Phase> phases = new ArrayList<Phase>();
        if ((PHASE_COLLECT & exclude) != PHASE_COLLECT) {
            phases.add(new Collect(100));
        }
        if ((PHASE_UNCONFIGURE & exclude) != PHASE_UNCONFIGURE) {
            phases.add(new Unconfigure(10, forcedUninstall));
        }
        if ((PHASE_UNINSTALL & exclude) != PHASE_UNINSTALL) {
            phases.add(new Uninstall(50, forcedUninstall));
        }
        if ((PHASE_PROPERTY & exclude) != PHASE_PROPERTY) {
            phases.add(new Property(1));
        }
        if ((PHASE_CHECK_TRUST & exclude) != PHASE_CHECK_TRUST) {
            phases.add(new CheckTrust(10));
        }
        if ((PHASE_INSTALL & exclude) != PHASE_INSTALL) {
            phases.add(new Install(50));
        }
        if ((PHASE_CONFIGURE & exclude) != PHASE_CONFIGURE) {
            phases.add(new Configure(10));
        }
        return new DefaultPhaseSet(phases.toArray(new Phase[phases.size()]));
    }
}

