/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.ui.ridgets.validation;

import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.core.util.PropertiesUtils;
import org.eclipse.riena.ui.ridgets.validation.ValidationFailure;
import org.eclipse.riena.ui.ridgets.validation.ValidationRuleStatus;

public class MinLength
implements IValidator,
IExecutableExtension {
    private int minLength;

    public MinLength() {
    }

    public MinLength(int minLength) {
        this.minLength = minLength;
    }

    public IStatus validate(Object value) {
        if (value == null) {
            if (this.minLength > 0) {
                return ValidationRuleStatus.error(false, "rule treats null as a blank string, which is shorter than " + this.minLength + " characters.");
            }
            return ValidationRuleStatus.ok();
        }
        if (value instanceof String) {
            String string = (String)value;
            if (string.length() >= this.minLength) {
                return ValidationRuleStatus.ok();
            }
            return ValidationRuleStatus.error(false, "String '" + string + "' is less than " + this.minLength + " characters long.");
        }
        throw new ValidationFailure(String.valueOf(this.getClass().getName()) + " can only validate objects of type " + String.class.getName());
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(this.getClass().getSimpleName());
        buffer.append("[minLength=");
        buffer.append(this.minLength);
        buffer.append("]");
        return buffer.toString();
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        if (data instanceof String) {
            String[] args = PropertiesUtils.asArray((Object)data);
            this.minLength = Integer.parseInt(args[0]);
        }
    }
}

