/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import java.util.Arrays;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.ui.ridgets.AbstractMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public final class SnippetMasterDetailsRidget005 {
    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = UIControlsFactory.createShell((Display)display);
        shell.setText(SnippetMasterDetailsRidget005.class.getSimpleName());
        shell.setLayout((Layout)new FillLayout());
        PersonMasterDetails details = new PersonMasterDetails((Composite)shell, 0);
        IMasterDetailsRidget ridget = (IMasterDetailsRidget)SwtRidgetFactory.createRidget((Object)((Object)details));
        ridget.setDelegate((IMasterDetailsDelegate)new PersonDelegate());
        String text = "Select a 'Jackson' do see different suggestion in the Combo.\nThis is updated dynamically when an item is selected.";
        Label info = UIControlsFactory.createLabel((Composite)details, (String)text, (int)64);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)info);
        WritableList input = new WritableList(PersonFactory.createPersonList(), Person.class);
        String[] properties = new String[]{"lastname", "firstname"};
        String[] headers = new String[]{"Last Name", "First Name"};
        ridget.bindToModel((IObservableList)input, Person.class, properties, headers);
        ridget.updateFromModel();
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static final class PersonDelegate
    extends AbstractMasterDetailsDelegate {
        private final Person workingCopy = this.createWorkingCopy();
        private IComboRidget combo;

        private PersonDelegate() {
        }

        public void configureRidgets(IRidgetContainer container) {
            WritableList options = new WritableList(Arrays.asList("empty"), String.class);
            IObservableValue selection = PojoObservables.observeValue((Object)this.workingCopy, (String)"firstname");
            this.combo = (IComboRidget)container.getRidget("combo");
            this.combo.bindToModel((IObservableList)options, String.class, null, selection);
        }

        public void prepareItemSelected(Object newSelection) {
            if (newSelection == null) {
                return;
            }
            Person person = (Person)newSelection;
            WritableList values = null;
            values = person.getLastname().startsWith("Jackson") ? new WritableList(Arrays.asList("Jackie", "Tito", "Jermaine", "Marlon", "Michael", "Janet", "Joseph", "Katherine"), String.class) : new WritableList(Arrays.asList("Joey", "Jack", "Jane", "Frank", "John"), String.class);
            IObservableValue selection = PojoObservables.observeValue((Object)this.workingCopy, (String)"firstname");
            this.combo.bindToModel((IObservableList)values, String.class, null, selection);
            this.combo.setSelection((Object)person.getFirstname());
            this.combo.updateFromModel();
        }

        public Person copyBean(Object source, Object target) {
            Person from = source != null ? (Person)source : this.createWorkingCopy();
            Person to = target != null ? (Person)target : this.createWorkingCopy();
            to.setFirstname(from.getFirstname());
            return to;
        }

        public Person createWorkingCopy() {
            return new Person("", "");
        }

        public Person getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isChanged(Object source, Object target) {
            Person p1 = (Person)source;
            Person p2 = (Person)target;
            boolean equal = p1.getFirstname().equals(p2.getFirstname());
            return !equal;
        }
    }

    private static final class PersonMasterDetails
    extends MasterDetailsComposite {
        PersonMasterDetails(Composite parent, int style) {
            super(parent, style, 1024);
            this.setMargins(5, 5);
        }

        protected void createDetails(Composite parent) {
            GridLayoutFactory.fillDefaults().numColumns(1).margins(20, 20).spacing(10, 10).equalWidth(false).applyTo(parent);
            GridDataFactory hFill = GridDataFactory.fillDefaults().grab(true, false);
            UIControlsFactory.createLabel((Composite)parent, (String)"First Name:");
            Combo combo = UIControlsFactory.createCombo((Composite)parent, (String)"combo");
            hFill.applyTo((Control)combo);
        }

        protected Button createButtonNew(Composite compButton) {
            return null;
        }
    }
}

