/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.sample.snippets;

import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.AbstractMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.swt.SwtRidgetFactory;
import org.eclipse.riena.ui.ridgets.validation.NotEmpty;
import org.eclipse.riena.ui.swt.MasterDetailsComposite;
import org.eclipse.riena.ui.swt.utils.UIControlsFactory;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public final class SnippetMasterDetailsRidget006 {
    private SnippetMasterDetailsRidget006() {
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = UIControlsFactory.createShell((Display)display);
        shell.setText(SnippetMasterDetailsRidget006.class.getSimpleName());
        shell.setLayout((Layout)new FillLayout());
        PersonMasterDetails details = new PersonMasterDetails((Composite)shell, 0);
        Button btnRename = UIControlsFactory.createButton((Composite)details, (String)"&Rename");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)btnRename);
        final IMasterDetailsRidget ridget = (IMasterDetailsRidget)SwtRidgetFactory.createRidget((Object)((Object)details));
        final PersonDelegate delegate = new PersonDelegate();
        ridget.setDelegate((IMasterDetailsDelegate)delegate);
        WritableList input = new WritableList(PersonFactory.createPersonList(), Person.class);
        String[] properties = new String[]{"lastname", "firstname"};
        String[] headers = new String[]{"Last Name", "First Name"};
        ridget.bindToModel((IObservableList)input, Person.class, properties, headers);
        ridget.updateFromModel();
        IActionRidget btnRidget = (IActionRidget)SwtRidgetFactory.createRidget((Object)btnRename);
        btnRidget.addListener(new IActionListener(){

            public void callback() {
                delegate.rename();
                ridget.updateApplyButton();
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    private static final class PersonDelegate
    extends AbstractMasterDetailsDelegate {
        private final Person workingCopy = this.createWorkingCopy();
        private ITextRidget txtLast;
        private ITextRidget txtFirst;

        private PersonDelegate() {
        }

        public void configureRidgets(IRidgetContainer container) {
            this.txtLast = (ITextRidget)container.getRidget(ITextRidget.class, "txtLast");
            this.txtLast.bindToModel((Object)this.workingCopy, "lastname");
            this.txtLast.addValidationRule((IValidator)new NotEmpty(), ValidationTime.ON_UI_CONTROL_EDIT);
            this.txtLast.updateFromModel();
            this.txtFirst = (ITextRidget)container.getRidget(ITextRidget.class, "txtFirst");
            this.txtFirst.bindToModel((Object)this.workingCopy, "firstname");
            this.txtFirst.updateFromModel();
        }

        public Person copyBean(Object source, Object target) {
            Person from = source != null ? (Person)source : this.createWorkingCopy();
            Person to = target != null ? (Person)target : this.createWorkingCopy();
            to.setFirstname(from.getFirstname());
            to.setLastname(from.getLastname());
            return to;
        }

        public Person createWorkingCopy() {
            return new Person("", "");
        }

        public Person getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isChanged(Object source, Object target) {
            Person p1 = (Person)source;
            Person p2 = (Person)target;
            boolean equal = p1.getFirstname().equals(p2.getFirstname()) && p1.getLastname().equals(p2.getLastname());
            return !equal;
        }

        public String isValid(IRidgetContainer container) {
            ITextRidget txtLast = (ITextRidget)container.getRidget("txtLast");
            if (txtLast.isErrorMarked()) {
                return "'Last Name' is not valid.";
            }
            return null;
        }

        public void rename() {
            this.workingCopy.setLastname("Changed");
            this.txtLast.updateFromModel();
            this.workingCopy.setFirstname(String.valueOf(System.currentTimeMillis()));
            this.txtFirst.updateFromModel();
        }
    }

    private static final class PersonMasterDetails
    extends MasterDetailsComposite {
        PersonMasterDetails(Composite parent, int style) {
            super(parent, style, 1024);
            this.setMargins(5, 5);
        }

        protected void createDetails(Composite parent) {
            GridLayoutFactory.fillDefaults().numColumns(2).margins(20, 20).spacing(10, 10).equalWidth(false).applyTo(parent);
            GridDataFactory hFill = GridDataFactory.fillDefaults().grab(true, false);
            UIControlsFactory.createLabel((Composite)parent, (String)"Last Name:");
            Text txtLast = UIControlsFactory.createText((Composite)parent);
            hFill.applyTo((Control)txtLast);
            this.addUIControl(txtLast, "txtLast");
            UIControlsFactory.createLabel((Composite)parent, (String)"First Name:");
            Text txtFirst = UIControlsFactory.createText((Composite)parent);
            hFill.applyTo((Control)txtFirst);
            this.addUIControl(txtFirst, "txtFirst");
        }
    }
}

