/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.prefs.PreferenceInitializer;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.p2.engine.ProfileScope;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.eclipse.ui.statushandlers.StatusManager;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class ProvSDKUIActivator
extends AbstractUIPlugin {
    private static final String LICENSE_STORAGE = "licenses.xml";
    private static ProvSDKUIActivator plugin;
    private static BundleContext context;
    private ScopedPreferenceStore preferenceStore;
    private IPropertyChangeListener preferenceListener;
    public static final String PLUGIN_ID = "org.eclipse.equinox.p2.ui.sdk";
    static /* synthetic */ Class class$0;

    public static BundleContext getContext() {
        return context;
    }

    public static ProvSDKUIActivator getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return ProvSDKUIActivator.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        plugin = this;
        context = bundleContext;
        this.readLicenseRegistry();
        PreferenceInitializer.migratePreferences();
        this.getPreferenceStore().addPropertyChangeListener(this.getPreferenceListener());
    }

    private IPropertyChangeListener getPreferenceListener() {
        if (this.preferenceListener == null) {
            this.preferenceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ProvSDKUIActivator.this.updateWithPreferences(ProvSDKUIActivator.this.getPolicy());
                }
            };
        }
        return this.preferenceListener;
    }

    public ProvisioningUI getProvisioningUI() {
        return ProvisioningUI.getDefaultUI();
    }

    private Policy getPolicy() {
        return this.getProvisioningUI().getPolicy();
    }

    private LicenseManager getLicenseManager() {
        BundleContext bundleContext = ProvSDKUIActivator.getContext();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.p2.ui.LicenseManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return (LicenseManager)ServiceHelper.getService((BundleContext)bundleContext, (String)clazz.getName());
    }

    private void readLicenseRegistry() {
        if (this.getLicenseManager() == null) {
            return;
        }
        IPath location = this.getStateLocation().append(LICENSE_STORAGE);
        File f = location.toFile();
        BufferedInputStream stream = null;
        if (f.exists()) {
            try {
                stream = new BufferedInputStream(new FileInputStream(f));
                this.getLicenseManager().read((InputStream)stream);
                stream.close();
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, PLUGIN_ID, 0, ProvSDKMessages.ProvSDKUIActivator_LicenseManagerReadError, (Throwable)e), 1);
            }
        }
    }

    private void writeLicenseRegistry() {
        if (this.getLicenseManager() == null) {
            return;
        }
        if (!this.getLicenseManager().hasAcceptedLicenses()) {
            return;
        }
        IPath location = this.getStateLocation().append(LICENSE_STORAGE);
        File f = location.toFile();
        BufferedOutputStream stream = null;
        try {
            stream = new BufferedOutputStream(new FileOutputStream(f, false));
            this.getLicenseManager().write((OutputStream)stream);
            stream.close();
        }
        catch (IOException e) {
            StatusManager.getManager().handle((IStatus)new Status(4, PLUGIN_ID, 0, ProvSDKMessages.ProvSDKUIActivator_ErrorWritingLicenseRegistry, (Throwable)e), 1);
        }
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.writeLicenseRegistry();
        plugin = null;
        this.getPreferenceStore().removePropertyChangeListener(this.preferenceListener);
        super.stop(bundleContext);
    }

    public IProvisioningEventBus getProvisioningEventBus() {
        ServiceReference busReference = context.getServiceReference(IProvisioningEventBus.SERVICE_NAME);
        if (busReference == null) {
            return null;
        }
        return (IProvisioningEventBus)context.getService(busReference);
    }

    static IStatus getNoSelfProfileStatus() {
        return new Status(2, PLUGIN_ID, ProvSDKMessages.ProvSDKUIActivator_NoSelfProfile);
    }

    void updateWithPreferences(Policy policy) {
        policy.setShowLatestVersionsOnly(this.getPreferenceStore().getBoolean("showLatestVersion"));
    }

    public IPreferenceStore getPreferenceStore() {
        if (this.preferenceStore == null) {
            this.preferenceStore = new ScopedPreferenceStore((IScopeContext)new ProfileScope("_SELF_"), PLUGIN_ID);
        }
        return this.preferenceStore;
    }

    public void savePreferences() {
        if (this.preferenceStore != null) {
            try {
                this.preferenceStore.save();
            }
            catch (IOException e) {
                StatusManager.getManager().handle((IStatus)new Status(4, PLUGIN_ID, 0, ProvSDKMessages.ProvSDKUIActivator_ErrorSavingPrefs, (Throwable)e), 3);
            }
        }
    }
}

