/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKUIActivator;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.query.GroupQuery;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.ui.Policy;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.statushandlers.StatusManager;

public class SDKPolicy
extends Policy {
    public SDKPolicy() {
        this.setVisibleAvailableIUQuery((IQuery)new GroupQuery());
        this.setVisibleInstalledIUQuery((IQuery)new UserVisibleRootQuery());
        this.setRepositoryPreferencePageId("org.eclipse.equinox.internal.p2.ui.sdk.SitesPreferencePage");
        this.setRepositoryPreferencePageName(ProvSDKMessages.SDKPolicy_PrefPageName);
        ProvSDKUIActivator.getDefault().updateWithPreferences(this);
    }

    public IStatus getNoProfileChosenStatus() {
        return ProvSDKUIActivator.getNoSelfProfileStatus();
    }

    public boolean continueWorkingOperation(ProfileChangeOperation operation, Shell shell) {
        boolean ok = super.continueWorkingWithOperation(operation, shell);
        if (!ok) {
            return false;
        }
        IProvisioningPlan plan = operation.getProvisioningPlan();
        if (plan == null) {
            return false;
        }
        IPreferenceStore prefs = ProvSDKUIActivator.getDefault().getPreferenceStore();
        String openPlan = prefs.getString("allowNonOKPlan");
        if ("always".equals(openPlan)) {
            return true;
        }
        if ("never".equals(openPlan)) {
            StatusManager.getManager().handle(plan.getStatus(), 3);
            return false;
        }
        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoCancelQuestion((Shell)shell, (String)ProvSDKMessages.ProvSDKUIActivator_Question, (String)ProvSDKMessages.ProvSDKUIActivator_OpenWizardAnyway, null, (boolean)false, (IPreferenceStore)prefs, (String)"allowNonOKPlan");
        if (dialog.getReturnCode() == 3) {
            StatusManager.getManager().handle(plan.getStatus(), 3);
        }
        return dialog.getReturnCode() == 2;
    }
}

