/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.sdk;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.ui.sdk.ProvSDKMessages;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.ui.LicenseManager;
import org.eclipse.ui.statushandlers.StatusManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SimpleLicenseManager
extends LicenseManager {
    Set accepted = new HashSet();

    public boolean accept(ILicense license) {
        this.accepted.add(license.getUUID());
        return true;
    }

    public boolean reject(ILicense license) {
        this.accepted.remove(license.getUUID());
        return true;
    }

    public boolean isAccepted(ILicense license) {
        return this.accepted.contains(license.getUUID());
    }

    public boolean hasAcceptedLicenses() {
        return !this.accepted.isEmpty();
    }

    public void read(InputStream stream) throws IOException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder parser = factory.newDocumentBuilder();
            Document doc = parser.parse(stream);
            Element root = doc.getDocumentElement();
            this.processRoot(root, this.accepted);
        }
        catch (ParserConfigurationException e) {
            this.handleException(e, ProvSDKMessages.ProvUILicenseManager_ParsingError, 1);
        }
        catch (SAXException e) {
            this.handleException(e, ProvSDKMessages.ProvUILicenseManager_ParsingError, 1);
        }
    }

    private void handleException(Throwable t, String message, int style) {
        if (message == null && t != null) {
            message = t.getMessage();
        }
        Status status = new Status(4, "org.eclipse.equinox.p2.ui.sdk", 0, message, t);
        StatusManager.getManager().handle((IStatus)status, style);
    }

    public void write(OutputStream stream) throws IOException {
        OutputStreamWriter osw = null;
        PrintWriter writer = null;
        try {
            osw = new OutputStreamWriter(stream, "UTF8");
            writer = new PrintWriter(osw);
            writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            writer.println("<licenses>");
            Iterator i = this.accepted.iterator();
            while (i.hasNext()) {
                String digest = (String)i.next();
                writer.print("    <license digest=\"" + digest + "\"/>");
            }
        }
        finally {
            writer.println("</licenses>");
            writer.flush();
            writer.close();
            if (osw != null) {
                osw.close();
            }
        }
    }

    private void processRoot(Node root, Set licenses) {
        if (root.getNodeName().equals("licenses")) {
            NodeList children = root.getChildNodes();
            this.processChildren(children, licenses);
        }
    }

    private void processChildren(NodeList children, Set licenses) {
        int i = 0;
        while (i < children.getLength()) {
            NamedNodeMap atts;
            Node digestAtt;
            Node child = children.item(i);
            if (child.getNodeType() == 1 && child.getNodeName().equals("license") && (digestAtt = (atts = child.getAttributes()).getNamedItem("digest")) != null) {
                licenses.add(digestAtt.getNodeValue());
            }
            ++i;
        }
    }
}

