/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.repository.Messages;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryIO;
import org.eclipse.equinox.internal.p2.persistence.CompositeRepositoryState;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.ICompositeRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.spi.AbstractMetadataRepository;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeMetadataRepository
extends AbstractMetadataRepository
implements IMetadataRepository,
ICompositeRepository<IInstallableUnit> {
    public static final String REPOSITORY_TYPE;
    public static final String PI_REPOSITORY_TYPE = "compositeMetadataRepository";
    private static final Integer REPOSITORY_VERSION;
    public static final String XML_EXTENSION = ".xml";
    private static final String JAR_EXTENSION = ".jar";
    private List<URI> childrenURIs = new ArrayList<URI>();
    private List<IMetadataRepository> loadedRepos = new ArrayList<IMetadataRepository>();
    private IMetadataRepositoryManager manager;

    static {
        Class<?> clazz;
        try {
            clazz = Class.forName("org.eclipse.equinox.internal.p2.metadata.repository.CompositeMetadataRepository");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        REPOSITORY_TYPE = clazz.getName();
        REPOSITORY_VERSION = new Integer(1);
    }

    public static CompositeMetadataRepository createMemoryComposite(IProvisioningAgent agent) {
        if (agent == null) {
            return null;
        }
        IMetadataRepositoryManager repoManager = (IMetadataRepositoryManager)agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
        if (repoManager == null) {
            return null;
        }
        try {
            long time = System.currentTimeMillis();
            URI repositoryURI = new URI(new StringBuffer("memory:").append(String.valueOf(time)).toString());
            while (repoManager.contains(repositoryURI)) {
                repositoryURI = new URI(new StringBuffer("memory:").append(String.valueOf(++time)).toString());
            }
            CompositeMetadataRepository result = (CompositeMetadataRepository)repoManager.createRepository(repositoryURI, repositoryURI.toString(), "org.eclipse.equinox.p2.metadata.repository.compositeRepository", null);
            repoManager.removeRepository(repositoryURI);
            return result;
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
        catch (URISyntaxException uRISyntaxException) {}
        return null;
    }

    private IMetadataRepositoryManager getManager() {
        return this.manager;
    }

    private boolean isLocal() {
        return "file".equalsIgnoreCase(this.location.getScheme());
    }

    public boolean isModifiable() {
        return this.isLocal();
    }

    CompositeMetadataRepository(IMetadataRepositoryManager manager, URI location, String name, Map<String, String> properties) {
        super(name == null ? (location != null ? location.toString() : "") : name, REPOSITORY_TYPE, REPOSITORY_VERSION.toString(), location, null, null, properties);
        this.manager = manager;
        this.save();
    }

    CompositeMetadataRepository(IMetadataRepositoryManager manager, CompositeRepositoryState state) {
        super(state.getName(), state.getType(), state.getVersion(), state.getLocation(), state.getDescription(), state.getProvider(), state.getProperties());
        this.manager = manager;
        int i = 0;
        while (i < state.getChildren().length) {
            this.addChild(state.getChildren()[i], false);
            ++i;
        }
    }

    public CompositeRepositoryState toState() {
        CompositeRepositoryState result = new CompositeRepositoryState();
        result.setName(this.getName());
        result.setType(this.getType());
        result.setVersion(this.getVersion());
        result.setLocation(this.getLocation());
        result.setDescription(this.getDescription());
        result.setProvider(this.getProvider());
        result.setProperties(this.getProperties());
        result.setChildren(this.childrenURIs.toArray(new URI[this.childrenURIs.size()]));
        return result;
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            CompoundQueryable queryable = new CompoundQueryable(this.loadedRepos);
            IQueryResult iQueryResult = queryable.query(query, monitor);
            return iQueryResult;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void addChild(URI childURI, boolean save) {
        URI absolute = URIUtil.makeAbsolute((URI)childURI, (URI)this.location);
        if (this.childrenURIs.contains(childURI) || this.childrenURIs.contains(absolute)) {
            return;
        }
        this.childrenURIs.add(childURI);
        if (save) {
            this.save();
        }
        try {
            boolean currentLoaded = this.getManager().contains(absolute);
            IMetadataRepository currentRepo = this.getManager().loadRepository(absolute, null);
            if (!currentLoaded) {
                this.getManager().setEnabled(absolute, false);
                this.getManager().setRepositoryProperty(absolute, "p2.system", String.valueOf(true));
            }
            this.loadedRepos.add(currentRepo);
        }
        catch (ProvisionException e) {
            LogHelper.log((ProvisionException)e);
        }
    }

    public void addChild(URI childURI) {
        this.addChild(childURI, true);
    }

    public void removeChild(URI childURI) {
        URI other;
        boolean removed = this.childrenURIs.remove(childURI);
        URI uRI = other = childURI.isAbsolute() ? URIUtil.makeRelative((URI)childURI, (URI)this.location) : URIUtil.makeAbsolute((URI)childURI, (URI)this.location);
        if (!removed) {
            removed = this.childrenURIs.remove(other);
        }
        if (removed) {
            IMetadataRepository found = null;
            for (IMetadataRepository current : this.loadedRepos) {
                URI repoLocation = current.getLocation();
                if (!URIUtil.sameURI((URI)childURI, (URI)repoLocation) && !URIUtil.sameURI((URI)other, (URI)repoLocation)) continue;
                found = current;
                break;
            }
            if (found != null) {
                this.loadedRepos.remove(found);
            }
            this.save();
        }
    }

    public void removeAllChildren() {
        this.childrenURIs.clear();
        this.loadedRepos.clear();
        this.save();
    }

    public synchronized void addInstallableUnits(IInstallableUnit[] installableUnits) {
        throw new UnsupportedOperationException("Cannot add IUs to a composite repository");
    }

    public synchronized void removeAll() {
        throw new UnsupportedOperationException("Cannot remove IUs to a composite repository");
    }

    public synchronized boolean removeInstallableUnits(IInstallableUnit[] installableUnits, IProgressMonitor monitor) {
        throw new UnsupportedOperationException("Cannot remove IUs to a composite repository");
    }

    private static File getActualLocation(URI location, String extension) {
        File spec = URIUtil.toFile((URI)location);
        String path = spec.getAbsolutePath();
        if (path.endsWith(new StringBuffer("compositeContent").append(extension).toString())) {
            return spec;
        }
        path = path.endsWith("/") ? new StringBuffer(String.valueOf(path)).append("compositeContent").toString() : new StringBuffer(String.valueOf(path)).append("/compositeContent").toString();
        return new File(new StringBuffer(String.valueOf(path)).append(extension).toString());
    }

    public static File getActualLocation(URI location) {
        return CompositeMetadataRepository.getActualLocation(location, XML_EXTENSION);
    }

    public synchronized void addReference(URI repositoryLocation, int repositoryType, int options) {
        throw new UnsupportedOperationException("Cannot add References to a composite repository");
    }

    private void save() {
        if (!this.isModifiable()) {
            return;
        }
        File file = CompositeMetadataRepository.getActualLocation(this.location);
        File jarFile = CompositeMetadataRepository.getActualLocation(this.location, JAR_EXTENSION);
        boolean compress = "true".equalsIgnoreCase((String)this.properties.get("p2.compressed"));
        try {
            OutputStream output = null;
            if (!compress) {
                if (jarFile.exists()) {
                    jarFile.delete();
                }
                if (!file.exists()) {
                    if (!file.getParentFile().exists()) {
                        file.getParentFile().mkdirs();
                    }
                    file.createNewFile();
                }
                output = new FileOutputStream(file);
            } else {
                if (file.exists()) {
                    file.delete();
                }
                if (!jarFile.exists()) {
                    if (!jarFile.getParentFile().exists()) {
                        jarFile.getParentFile().mkdirs();
                    }
                    jarFile.createNewFile();
                }
                JarEntry jarEntry = new JarEntry(file.getName());
                JarOutputStream jOutput = new JarOutputStream(new FileOutputStream(jarFile));
                jOutput.putNextEntry(jarEntry);
                output = jOutput;
            }
            super.setProperty("p2.timestamp", Long.toString(System.currentTimeMillis()));
            new CompositeRepositoryIO().write(this.toState(), output, PI_REPOSITORY_TYPE);
        }
        catch (IOException e) {
            LogHelper.log((IStatus)new Status(4, "org.eclipse.equinox.p2.metadata.repository", 1003, NLS.bind((String)Messages.io_failedWrite, (Object)this.location), (Throwable)e));
        }
    }

    public List<URI> getChildren() {
        ArrayList<URI> result = new ArrayList<URI>();
        for (URI childURI : this.childrenURIs) {
            result.add(URIUtil.makeAbsolute((URI)childURI, (URI)this.location));
        }
        return result;
    }

    public static URI getActualLocationURI(URI base, String extension) {
        if (extension == null) {
            extension = XML_EXTENSION;
        }
        return URIUtil.append((URI)base, (String)new StringBuffer("compositeContent").append(extension).toString());
    }

    public void initialize(AbstractMetadataRepository.RepositoryState state) {
        this.name = state.Name;
        this.type = state.Type;
        this.version = state.Version.toString();
        this.provider = state.Provider;
        this.description = state.Description;
        this.location = state.Location;
        this.properties = state.Properties;
    }
}

