/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IUMap {
    final Map<String, Object> units = new HashMap<String, Object>();

    public void add(IInstallableUnit unit) {
        String key = unit.getId();
        Object matching = this.units.get(key);
        if (matching == null) {
            this.units.put(key, unit);
            return;
        }
        if (matching.getClass().isArray()) {
            IInstallableUnit[] iuArr = (IInstallableUnit[])matching;
            int idx = iuArr.length;
            while (--idx >= 0) {
                if (!iuArr[idx].equals((Object)unit)) continue;
                return;
            }
            IInstallableUnit[] iuArrPlus = new IInstallableUnit[iuArr.length + 1];
            System.arraycopy(iuArr, 0, iuArrPlus, 0, iuArr.length);
            iuArrPlus[iuArr.length] = unit;
            this.units.put(unit.getId(), iuArrPlus);
        } else {
            IInstallableUnit old = (IInstallableUnit)matching;
            if (!old.equals((Object)unit)) {
                this.units.put(key, new IInstallableUnit[]{old, unit});
            }
        }
    }

    public void addAll(IInstallableUnit[] toAdd) {
        int i = 0;
        while (i < toAdd.length) {
            this.add(toAdd[i]);
            ++i;
        }
    }

    public void clear() {
        this.units.clear();
    }

    public Iterator<IInstallableUnit> iterator() {
        return new MapIterator();
    }

    public IQueryResult<IInstallableUnit> query(InstallableUnitQuery query) {
        Iterator<Object> candidates;
        if (query.getId() == null) {
            candidates = this.iterator();
        } else {
            Object bucket = this.units.get(query.getId());
            if (bucket == null) {
                return Collector.emptyCollector();
            }
            candidates = bucket.getClass().isArray() ? CollectionUtils.unmodifiableList((Object[])((IInstallableUnit[])bucket)).iterator() : Collections.singletonList((IInstallableUnit)bucket).iterator();
        }
        return query.perform(candidates);
    }

    public void remove(IInstallableUnit unit) {
        String key = unit.getId();
        Object matching = this.units.get(key);
        if (matching == null) {
            return;
        }
        if (matching instanceof IInstallableUnit && matching.equals(unit)) {
            this.units.remove(key);
            return;
        }
        IInstallableUnit[] array = (IInstallableUnit[])matching;
        int idx = array.length;
        while (--idx >= 0) {
            if (!unit.equals((Object)array[idx])) continue;
            if (array.length == 2) {
                this.units.put(key, idx == 0 ? array[1] : array[0]);
                break;
            }
            IInstallableUnit[] newArray = new IInstallableUnit[array.length - 1];
            if (idx > 0) {
                System.arraycopy(array, 0, newArray, 0, idx);
            }
            if (idx + 1 < array.length) {
                System.arraycopy(array, idx + 1, newArray, idx, array.length - (idx + 1));
            }
            this.units.put(key, newArray);
            break;
        }
    }

    public void removeAll(Collection<IInstallableUnit> toRemove) {
        for (IInstallableUnit iu : toRemove) {
            this.remove(iu);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class MapIterator
    implements Iterator<IInstallableUnit> {
        private final Iterator<Object> unitIterator;
        private IInstallableUnit[] currentBucket;
        private int bucketIndex = 0;
        private IInstallableUnit nextElement = null;

        MapIterator() {
            this.unitIterator = IUMap.this.units.values().iterator();
        }

        @Override
        public boolean hasNext() {
            return this.positionNext();
        }

        @Override
        public IInstallableUnit next() {
            if (!this.positionNext()) {
                throw new NoSuchElementException();
            }
            IInstallableUnit nxt = this.nextElement;
            this.nextElement = null;
            return nxt;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private boolean positionNext() {
            if (this.nextElement != null) {
                return true;
            }
            if (this.currentBucket != null) {
                this.nextElement = this.currentBucket[this.bucketIndex];
                if (++this.bucketIndex == this.currentBucket.length) {
                    this.currentBucket = null;
                    this.bucketIndex = -1;
                }
                return true;
            }
            if (!this.unitIterator.hasNext()) {
                return false;
            }
            Object val = this.unitIterator.next();
            if (val instanceof IInstallableUnit) {
                this.nextElement = (IInstallableUnit)val;
            } else {
                this.currentBucket = (IInstallableUnit[])val;
                this.nextElement = this.currentBucket[0];
                this.bucketIndex = 1;
            }
            return true;
        }
    }
}

