/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.metadata.repository.io;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.metadata.IRequiredCapability;
import org.eclipse.equinox.internal.p2.metadata.repository.io.XMLConstants;
import org.eclipse.equinox.internal.p2.persistence.XMLWriter;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.ICopyright;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.ILicense;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.ITouchpointData;
import org.eclipse.equinox.p2.metadata.ITouchpointInstruction;
import org.eclipse.equinox.p2.metadata.ITouchpointType;
import org.eclipse.equinox.p2.metadata.IUpdateDescriptor;
import org.eclipse.equinox.p2.metadata.query.FragmentQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MetadataWriter
extends XMLWriter
implements XMLConstants {
    public MetadataWriter(OutputStream output, XMLWriter.ProcessingInstruction[] piElements) throws UnsupportedEncodingException {
        super(output, piElements);
    }

    protected void writeInstallableUnits(Iterator<IInstallableUnit> units, int size) {
        if (size == 0) {
            return;
        }
        this.start("units");
        this.attribute("size", size);
        while (units.hasNext()) {
            this.writeInstallableUnit(units.next());
        }
        this.end("units");
    }

    protected void writeInstallableUnit(IInstallableUnit resolvedIU) {
        IInstallableUnit iu = resolvedIU.unresolved();
        this.start("unit");
        this.attribute("id", iu.getId());
        this.attribute("version", iu.getVersion());
        this.attribute("singleton", iu.isSingleton(), true);
        if (FragmentQuery.isFragment((IInstallableUnit)iu) && iu instanceof IInstallableUnitFragment) {
            IInstallableUnitFragment fragment = (IInstallableUnitFragment)iu;
            this.writeHostRequiredCapabilities(fragment.getHost());
        }
        if (iu instanceof IInstallableUnitPatch) {
            IInstallableUnitPatch patch = (IInstallableUnitPatch)iu;
            this.writeApplicabilityScope(patch.getApplicabilityScope());
            this.writeRequirementsChange(patch.getRequirementsChange());
            this.writeLifeCycle(patch.getLifeCycle());
        }
        this.writeUpdateDescriptor(resolvedIU, resolvedIU.getUpdateDescriptor());
        this.writeProperties(iu.getProperties());
        this.writeMetaRequiredCapabilities(iu.getMetaRequiredCapabilities());
        this.writeProvidedCapabilities(iu.getProvidedCapabilities());
        this.writeRequiredCapabilities(iu.getRequiredCapabilities());
        this.writeTrimmedCdata("filter", iu.getFilter() == null ? null : iu.getFilter().toString());
        this.writeArtifactKeys(iu.getArtifacts());
        this.writeTouchpointType(iu.getTouchpointType());
        this.writeTouchpointData(iu.getTouchpointData());
        this.writeLicenses(iu.getLicenses());
        this.writeCopyright(iu.getCopyright());
        this.end("unit");
    }

    protected void writeLifeCycle(IRequirement capability) {
        if (capability == null) {
            return;
        }
        this.start("lifeCycle");
        this.writeRequiredCapability(capability);
        this.end("lifeCycle");
    }

    protected void writeHostRequiredCapabilities(IRequirement[] capabilities) {
        if (capabilities != null && capabilities.length > 0) {
            this.start("hostRequirements");
            this.attribute("size", capabilities.length);
            int i = 0;
            while (i < capabilities.length) {
                this.writeRequiredCapability(capabilities[i]);
                ++i;
            }
            this.end("hostRequirements");
        }
    }

    protected void writeProvidedCapabilities(Collection<IProvidedCapability> capabilities) {
        if (capabilities != null && capabilities.size() > 0) {
            this.start("provides");
            this.attribute("size", capabilities.size());
            for (IProvidedCapability capability : capabilities) {
                this.start("provided");
                this.attribute("namespace", capability.getNamespace());
                this.attribute("name", capability.getName());
                this.attribute("version", capability.getVersion());
                this.end("provided");
            }
            this.end("provides");
        }
    }

    protected void writeMetaRequiredCapabilities(Collection<IRequirement> metaRequirements) {
        if (metaRequirements != null && metaRequirements.size() > 0) {
            this.start("metaRequirements");
            this.attribute("size", metaRequirements.size());
            for (IRequirement req : metaRequirements) {
                this.writeRequiredCapability(req);
            }
            this.end("metaRequirements");
        }
    }

    protected void writeRequiredCapabilities(Collection<IRequirement> requirements) {
        if (requirements != null && requirements.size() > 0) {
            this.start("requires");
            this.attribute("size", requirements.size());
            for (IRequirement req : requirements) {
                this.writeRequiredCapability(req);
            }
            this.end("requires");
        }
    }

    protected void writeUpdateDescriptor(IInstallableUnit iu, IUpdateDescriptor descriptor) {
        if (descriptor == null) {
            return;
        }
        this.start("update");
        this.attribute("id", descriptor.getId());
        this.attribute("range", descriptor.getRange());
        this.attribute("severity", descriptor.getSeverity());
        this.attribute("description", descriptor.getDescription());
        this.end("update");
    }

    protected void writeApplicabilityScope(IRequirement[][] capabilities) {
        this.start("patchScope");
        int i = 0;
        while (i < capabilities.length) {
            this.start("scope");
            this.writeRequiredCapabilities(Arrays.asList(capabilities[i]));
            this.end("scope");
            ++i;
        }
        this.end("patchScope");
    }

    protected void writeRequirementsChange(List<IRequirementChange> changes) {
        this.start("changes");
        int i = 0;
        while (i < changes.size()) {
            this.writeRequirementChange(changes.get(i));
            ++i;
        }
        this.end("changes");
    }

    protected void writeRequirementChange(IRequirementChange change) {
        this.start("change");
        if (change.applyOn() != null) {
            this.start("from");
            this.writeRequiredCapability((IRequirement)change.applyOn());
            this.end("from");
        }
        if (change.newValue() != null) {
            this.start("to");
            this.writeRequiredCapability((IRequirement)change.newValue());
            this.end("to");
        }
        this.end("change");
    }

    protected void writeRequiredCapability(IRequirement requirement) {
        if (requirement instanceof IRequiredCapability) {
            IRequiredCapability reqCapability = (IRequiredCapability)requirement;
            this.start("required");
            this.attribute("namespace", reqCapability.getNamespace());
            this.attribute("name", reqCapability.getName());
            this.attribute("range", reqCapability.getRange());
            this.attribute("optional", requirement.getMin() == 0, false);
            this.attribute("multiple", requirement.getMax() > 1, false);
            this.attribute("greedy", requirement.isGreedy(), true);
            if (requirement.getFilter() != null) {
                this.writeTrimmedCdata("filter", requirement.getFilter().toString());
            }
        } else {
            throw new IllegalStateException();
        }
        this.end("required");
    }

    protected void writeArtifactKeys(Collection<IArtifactKey> artifactKeys) {
        if (artifactKeys != null && artifactKeys.size() > 0) {
            this.start("artifacts");
            this.attribute("size", artifactKeys.size());
            for (IArtifactKey artifactKey : artifactKeys) {
                this.start("artifact");
                this.attribute("classifier", artifactKey.getClassifier());
                this.attribute("id", artifactKey.getId());
                this.attribute("version", artifactKey.getVersion());
                this.end("artifact");
            }
            this.end("artifacts");
        }
    }

    protected void writeTouchpointType(ITouchpointType touchpointType) {
        this.start("touchpoint");
        this.attribute("id", touchpointType.getId());
        this.attribute("version", touchpointType.getVersion());
        this.end("touchpoint");
    }

    protected void writeTouchpointData(List<ITouchpointData> touchpointData) {
        if (touchpointData != null && touchpointData.size() > 0) {
            this.start("touchpointData");
            this.attribute("size", touchpointData.size());
            int i = 0;
            while (i < touchpointData.size()) {
                ITouchpointData nextData = touchpointData.get(i);
                Map instructions = nextData.getInstructions();
                if (instructions.size() > 0) {
                    this.start("instructions");
                    this.attribute("size", instructions.size());
                    for (Map.Entry entry : instructions.entrySet()) {
                        this.start("instruction");
                        this.attribute("key", entry.getKey());
                        ITouchpointInstruction instruction = (ITouchpointInstruction)entry.getValue();
                        if (instruction.getImportAttribute() != null) {
                            this.attribute("import", instruction.getImportAttribute());
                        }
                        this.cdata(instruction.getBody(), true);
                        this.end("instruction");
                    }
                    this.end("instructions");
                }
                ++i;
            }
            this.end("touchpointData");
        }
    }

    private void writeTrimmedCdata(String element, String filter) {
        String trimmed;
        if (filter != null && (trimmed = filter.trim()).length() > 0) {
            this.start(element);
            this.cdata(trimmed);
            this.end(element);
        }
    }

    private void writeLicenses(Collection<ILicense> licenses) {
        if (licenses != null && licenses.size() > 0) {
            this.start("licenses");
            this.attribute("size", licenses.size());
            for (ILicense license : licenses) {
                if (license == null) continue;
                this.start("license");
                if (license.getLocation() != null) {
                    this.attribute("uri", license.getLocation().toString());
                    try {
                        this.attribute("url", URIUtil.toURL((URI)license.getLocation()).toExternalForm());
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.attribute("url", license.getLocation().toString());
                    }
                }
                this.cdata(license.getBody(), true);
                this.end("license");
            }
            this.end("licenses");
        }
    }

    private void writeCopyright(ICopyright copyright) {
        if (copyright != null) {
            this.start("copyright");
            try {
                if (copyright.getLocation() != null) {
                    this.attribute("uri", copyright.getLocation().toString());
                    try {
                        this.attribute("url", URIUtil.toURL((URI)copyright.getLocation()).toExternalForm());
                    }
                    catch (MalformedURLException malformedURLException) {
                        this.attribute("url", copyright.getLocation().toString());
                    }
                }
            }
            catch (IllegalStateException illegalStateException) {
                LogHelper.log((IStatus)new Status(1, "org.eclipse.equinox.p2.metadata.repository", new StringBuffer("Error writing the copyright URL: ").append(copyright.getLocation()).toString()));
            }
            this.cdata(copyright.getBody(), true);
            this.end("copyright");
        }
    }
}

