/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.security.common.authorization;

import java.security.Permission;
import org.eclipse.riena.core.injector.Inject;
import org.eclipse.riena.internal.security.common.Activator;
import org.eclipse.riena.security.common.authorization.ISentinelService;

public final class Sentinel {
    private ISentinelService sentinelService;
    private static final Sentinel SENTINEL = new Sentinel();

    private Sentinel() {
        Inject.service(ISentinelService.class).useRanking().into((Object)this).andStart(Activator.getDefault().getContext());
    }

    private static Sentinel getInstance() {
        return SENTINEL;
    }

    private ISentinelService getSentinelService() {
        return this.sentinelService;
    }

    public void bind(ISentinelService sentinelServiceParm) {
        this.sentinelService = sentinelServiceParm;
    }

    public void unbind(ISentinelService sentinelServiceParm) {
        this.sentinelService = null;
    }

    public static boolean checkAccess(Permission permission) {
        if (Sentinel.getInstance().getSentinelService() == null) {
            return false;
        }
        return Sentinel.getInstance().getSentinelService().checkAccess(permission);
    }
}

