/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.equinox.internal.provisional.p2.metadata.MetadataFactory;
import org.eclipse.equinox.p2.engine.InstallableUnitOperand;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitFragment;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OperationGenerator {
    private static final IInstallableUnit NULL_IU = MetadataFactory.createResolvedInstallableUnit((IInstallableUnit)MetadataFactory.createInstallableUnit((MetadataFactory.InstallableUnitDescription)new MetadataFactory.InstallableUnitDescription()), (IInstallableUnitFragment[])new IInstallableUnitFragment[0]);

    public List<InstallableUnitOperand> generateOperation(Collection<IInstallableUnit> from_, Collection<IInstallableUnit> to_) {
        HashSet<IInstallableUnit> intersection = new HashSet<IInstallableUnit>(from_);
        intersection.retainAll(to_);
        HashSet<IInstallableUnit> tmpFrom = new HashSet<IInstallableUnit>(from_);
        HashSet<IInstallableUnit> tmpTo = new HashSet<IInstallableUnit>(to_);
        tmpFrom.removeAll(intersection);
        tmpTo.removeAll(intersection);
        ArrayList<IInstallableUnit> from = new ArrayList<IInstallableUnit>(tmpFrom);
        Collections.sort(from);
        ArrayList<IInstallableUnit> to = new ArrayList<IInstallableUnit>(tmpTo);
        Collections.sort(to);
        ArrayList<InstallableUnitOperand> operations = new ArrayList<InstallableUnitOperand>();
        this.generateUpdates(from, to, operations);
        this.generateInstallUninstall(from, to, operations);
        this.generateConfigurationChanges(to_, intersection, operations);
        return operations;
    }

    private void generateConfigurationChanges(Collection<IInstallableUnit> to_, Collection<IInstallableUnit> intersection, ArrayList<InstallableUnitOperand> operations) {
        if (intersection.size() == 0) {
            return;
        }
        TreeSet<IInstallableUnit> to = new TreeSet<IInstallableUnit>(to_);
        for (IInstallableUnit fromIU : intersection) {
            IInstallableUnit toIU = to.tailSet(fromIU).first();
            this.generateConfigurationOperation(fromIU, toIU, operations);
        }
    }

    private void generateConfigurationOperation(IInstallableUnit fromIU, IInstallableUnit toIU, ArrayList<InstallableUnitOperand> operations) {
        List toFragments;
        List fromFragments = fromIU.getFragments();
        if (fromFragments == (toFragments = toIU.getFragments())) {
            return;
        }
        if (fromFragments.size() == toFragments.size() && fromFragments.containsAll(toFragments)) {
            return;
        }
        operations.add(new InstallableUnitOperand(fromIU, toIU));
    }

    private void generateInstallUninstall(List<IInstallableUnit> from, List<IInstallableUnit> to, ArrayList<InstallableUnitOperand> operations) {
        int toIdx = 0;
        int fromIdx = 0;
        while (fromIdx != from.size() && toIdx != to.size()) {
            IInstallableUnit fromIU = from.get(fromIdx);
            IInstallableUnit toIU = to.get(toIdx);
            int comparison = toIU.compareTo((Object)fromIU);
            if (comparison < 0) {
                operations.add(this.createInstallOperation(toIU));
                ++toIdx;
                continue;
            }
            if (comparison == 0) {
                ++toIdx;
                ++fromIdx;
                continue;
            }
            operations.add(this.createUninstallOperation(fromIU));
            ++fromIdx;
        }
        if (fromIdx != from.size()) {
            int i = fromIdx;
            while (i < from.size()) {
                operations.add(this.createUninstallOperation(from.get(i)));
                ++i;
            }
        }
        if (toIdx != to.size()) {
            int i = toIdx;
            while (i < to.size()) {
                operations.add(this.createInstallOperation(to.get(i)));
                ++i;
            }
        }
    }

    private void generateUpdates(List<IInstallableUnit> from, List<IInstallableUnit> to, ArrayList<InstallableUnitOperand> operations) {
        if (to.isEmpty() || from.isEmpty()) {
            return;
        }
        HashSet<IInstallableUnit> processed = new HashSet<IInstallableUnit>();
        HashSet<IInstallableUnit> removedFromTo = new HashSet<IInstallableUnit>();
        HashMap<String, ArrayList<IInstallableUnit>> fromById = new HashMap<String, ArrayList<IInstallableUnit>>();
        for (IInstallableUnit iuFrom : from) {
            ArrayList<IInstallableUnit> ius = (ArrayList<IInstallableUnit>)fromById.get(iuFrom.getId());
            if (ius == null) {
                ius = new ArrayList<IInstallableUnit>();
                fromById.put(iuFrom.getId(), ius);
            }
            ius.add(iuFrom);
        }
        int toIdx = 0;
        while (toIdx < to.size()) {
            InstallableUnitQuery updateQuery;
            Iterator updates;
            List fromIdIndexList;
            IInstallableUnit iuTo = to.get(toIdx);
            if (iuTo.getId().equals(this.next(to, toIdx).getId())) {
                toIdx = this.skip(to, iuTo, toIdx) - 1;
            } else if (iuTo.getUpdateDescriptor() != null && (fromIdIndexList = (List)fromById.get(iuTo.getUpdateDescriptor().getId())) != null && (updates = (updateQuery = new InstallableUnitQuery(iuTo.getUpdateDescriptor().getId(), iuTo.getUpdateDescriptor().getRange())).perform(fromIdIndexList.iterator()).iterator()).hasNext()) {
                IInstallableUnit iuFrom = (IInstallableUnit)updates.next();
                if (!updates.hasNext()) {
                    if (iuTo.equals((Object)iuFrom)) {
                        from.remove(iuFrom);
                        fromIdIndexList.remove(iuFrom);
                        removedFromTo.add(iuTo);
                    } else {
                        operations.add(this.createUpdateOperation(iuFrom, iuTo));
                        from.remove(iuFrom);
                        fromIdIndexList.remove(iuFrom);
                        processed.add(iuTo);
                    }
                }
            }
            ++toIdx;
        }
        to.removeAll(processed);
        to.removeAll(removedFromTo);
    }

    private InstallableUnitOperand createUninstallOperation(IInstallableUnit iu) {
        return new InstallableUnitOperand(iu, null);
    }

    private InstallableUnitOperand createInstallOperation(IInstallableUnit iu) {
        return new InstallableUnitOperand(null, iu);
    }

    private InstallableUnitOperand createUpdateOperation(IInstallableUnit from, IInstallableUnit to) {
        return new InstallableUnitOperand(from, to);
    }

    private IInstallableUnit next(List<IInstallableUnit> l, int i) {
        if (++i >= l.size()) {
            return NULL_IU;
        }
        return l.get(i);
    }

    private int skip(List<IInstallableUnit> c, IInstallableUnit id, int idx) {
        int i = idx;
        while (i < c.size()) {
            if (!id.getId().equals(c.get(i).getId())) {
                return i;
            }
            ++i;
        }
        return i;
    }
}

