/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.metadata.query.ExpressionQuery;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryableArray
implements IQueryable<IInstallableUnit> {
    private final List<IInstallableUnit> dataSet;
    private Map<String, List<IInstallableUnit>> namedCapabilityIndex;

    public QueryableArray(IInstallableUnit[] ius) {
        this.dataSet = Arrays.asList(ius);
    }

    public IQueryResult<IInstallableUnit> query(IQuery<IInstallableUnit> query, IProgressMonitor monitor) {
        if (query instanceof ExpressionQuery) {
            return this.queryCapability((ExpressionQuery<IInstallableUnit>)((ExpressionQuery)query), (Collector<IInstallableUnit>)new Collector(), monitor);
        }
        return query.perform(this.dataSet.iterator());
    }

    private Collector<IInstallableUnit> queryCapability(ExpressionQuery<IInstallableUnit> query, Collector<IInstallableUnit> collector, IProgressMonitor monitor) {
        this.generateNamedCapabilityIndex();
        Collection<IInstallableUnit> resultIUs = null;
        Collection<IInstallableUnit> matchingIUs = this.findMatchingIUs((IMatchExpression<IInstallableUnit>)query.getExpression());
        if (matchingIUs == null) {
            return collector;
        }
        if (resultIUs == null) {
            resultIUs = matchingIUs;
        } else {
            resultIUs.retainAll(matchingIUs);
        }
        if (resultIUs != null) {
            Iterator<IInstallableUnit> iterator = resultIUs.iterator();
            while (iterator.hasNext()) {
                collector.accept((Object)iterator.next());
            }
        }
        return collector;
    }

    private Collection<IInstallableUnit> findMatchingIUs(IMatchExpression<IInstallableUnit> requirementMatch) {
        List<IInstallableUnit> ius = this.namedCapabilityIndex.get(RequiredCapability.extractName(requirementMatch));
        if (ius == null) {
            return null;
        }
        HashSet<IInstallableUnit> matchingIUs = new HashSet<IInstallableUnit>();
        for (IInstallableUnit iu : ius) {
            if (!requirementMatch.isMatch((Object)iu)) continue;
            matchingIUs.add(iu);
        }
        return matchingIUs;
    }

    private void generateNamedCapabilityIndex() {
        if (this.namedCapabilityIndex != null) {
            return;
        }
        this.namedCapabilityIndex = new HashMap<String, List<IInstallableUnit>>();
        for (IInstallableUnit iu : this.dataSet) {
            Collection providedCapabilities = iu.getProvidedCapabilities();
            for (IProvidedCapability pc : providedCapabilities) {
                String name = pc.getName();
                List<IInstallableUnit> ius = this.namedCapabilityIndex.get(name);
                if (ius == null) {
                    ius = new ArrayList<IInstallableUnit>(5);
                    this.namedCapabilityIndex.put(name, ius);
                }
                ius.add(iu);
            }
        }
    }
}

