/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.director;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.internal.p2.core.helpers.LogHelper;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.internal.p2.director.Messages;
import org.eclipse.equinox.internal.p2.director.QueryableArray;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IInstallableUnitPatch;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.IRequirementChange;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.metadata.query.ExpressionQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Filter;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Slicer {
    private static boolean DEBUG = false;
    private IQueryable<IInstallableUnit> possibilites;
    private LinkedList<IInstallableUnit> toProcess;
    private Set<IInstallableUnit> considered;
    private Map<String, Map<Version, IInstallableUnit>> slice;
    protected Dictionary<? extends Object, ? extends Object> selectionContext;
    private MultiStatus result;
    private boolean considerMetaRequirements = false;

    public Slicer(IQueryable<IInstallableUnit> input, Dictionary<? extends Object, ? extends Object> context, boolean considerMetaRequirements) {
        this.possibilites = input;
        this.slice = new HashMap<String, Map<Version, IInstallableUnit>>();
        this.selectionContext = context;
        this.result = new MultiStatus("org.eclipse.equinox.p2.director", 0, Messages.Planner_Problems_resolving_plan, null);
        this.considerMetaRequirements = considerMetaRequirements;
    }

    public IQueryable<IInstallableUnit> slice(IInstallableUnit[] ius, IProgressMonitor monitor) {
        try {
            long start = 0L;
            if (DEBUG) {
                start = System.currentTimeMillis();
                System.out.println(new StringBuffer("Start slicing: ").append(start).toString());
            }
            this.validateInput(ius);
            this.considered = new HashSet<IInstallableUnit>(Arrays.asList(ius));
            this.toProcess = new LinkedList<IInstallableUnit>(this.considered);
            while (!this.toProcess.isEmpty()) {
                if (monitor.isCanceled()) {
                    this.result.merge(Status.CANCEL_STATUS);
                    throw new OperationCanceledException();
                }
                this.processIU(this.toProcess.removeFirst());
            }
            if (DEBUG) {
                long stop = System.currentTimeMillis();
                System.out.println(new StringBuffer("Slicing complete: ").append(stop - start).toString());
            }
        }
        catch (IllegalStateException e) {
            this.result.add((IStatus)new Status(4, "org.eclipse.equinox.p2.director", e.getMessage(), (Throwable)e));
        }
        if (Tracing.DEBUG && this.result.getSeverity() != 0) {
            LogHelper.log((IStatus)this.result);
        }
        if (this.result.getSeverity() == 4) {
            return null;
        }
        return new QueryableArray(this.considered.toArray(new IInstallableUnit[this.considered.size()]));
    }

    public MultiStatus getStatus() {
        return this.result;
    }

    private void validateInput(IInstallableUnit[] ius) {
        int i = 0;
        while (i < ius.length) {
            if (!this.isApplicable(ius[i])) {
                throw new IllegalStateException(new StringBuffer("The IU ").append(ius[i]).append(" can't be installed in this environment because its filter does not match.").toString());
            }
            ++i;
        }
    }

    protected boolean isApplicable(IRequirement req) {
        Filter filter = req.getFilter();
        return filter == null || filter.match(this.selectionContext);
    }

    protected boolean isApplicable(IInstallableUnit iu) {
        Filter filter = iu.getFilter();
        return filter == null || filter.match(this.selectionContext);
    }

    protected void processIU(IInstallableUnit iu) {
        Map<Version, IInstallableUnit> iuSlice = this.slice.get((iu = iu.unresolved()).getId());
        if (iuSlice == null) {
            iuSlice = new HashMap<Version, IInstallableUnit>();
            this.slice.put(iu.getId(), iuSlice);
        }
        iuSlice.put(iu.getVersion(), iu);
        if (!this.isApplicable(iu)) {
            return;
        }
        Collection<IRequirement> reqs = this.getRequiredCapabilities(iu);
        if (reqs.isEmpty()) {
            return;
        }
        for (IRequirement req : reqs) {
            if (!this.isApplicable(req) || !this.isGreedy(req)) continue;
            this.expandRequirement(iu, req);
        }
    }

    protected boolean isGreedy(IRequirement req) {
        return req.isGreedy();
    }

    private Collection<IRequirement> getRequiredCapabilities(IInstallableUnit iu) {
        Collection iuRequirements = iu.getRequiredCapabilities();
        int initialRequirementCount = iuRequirements.size();
        if (!(iu instanceof IInstallableUnitPatch)) {
            if (!this.considerMetaRequirements) {
                return iuRequirements;
            }
            Collection iuMetaRequirements = iu.getMetaRequiredCapabilities();
            int metaSize = iuMetaRequirements.size();
            if (metaSize == 0) {
                return iuRequirements;
            }
            ArrayList<IRequirement> aggregatedCapabilities = new ArrayList<IRequirement>(initialRequirementCount + metaSize);
            aggregatedCapabilities.addAll(iuRequirements);
            aggregatedCapabilities.addAll(iuMetaRequirements);
            return aggregatedCapabilities;
        }
        IInstallableUnitPatch patchIU = (IInstallableUnitPatch)iu;
        List changes = patchIU.getRequirementsChange();
        ArrayList<IRequirement> aggregatedCapabilities = new ArrayList<IRequirement>(initialRequirementCount + changes.size());
        aggregatedCapabilities.addAll(iuRequirements);
        int i = 0;
        while (i < changes.size()) {
            aggregatedCapabilities.add((IRequirement)((IRequirementChange)changes.get(i)).newValue());
            ++i;
        }
        return aggregatedCapabilities;
    }

    private void expandRequirement(IInstallableUnit iu, IRequirement req) {
        Class<?> clazz;
        if (req.getMax() == 0) {
            return;
        }
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        IQueryResult matches = this.possibilites.query((IQuery)new ExpressionQuery(clazz, req.getMatches()), null);
        int validMatches = 0;
        for (IInstallableUnit match : matches) {
            if (!this.isApplicable(match)) continue;
            ++validMatches;
            Map<Version, IInstallableUnit> iuSlice = this.slice.get(match.getId());
            if (iuSlice != null && iuSlice.containsKey(match.getVersion())) continue;
            this.consider(match);
        }
        if (validMatches == 0) {
            if (req.getMin() == 0) {
                if (DEBUG) {
                    System.out.println(new StringBuffer("No IU found to satisfy optional dependency of ").append(iu).append(" on req ").append(req).toString());
                }
            } else {
                this.result.add((IStatus)new Status(2, "org.eclipse.equinox.p2.director", NLS.bind((String)Messages.Planner_Unsatisfied_dependency, (Object)iu, (Object)req)));
            }
        }
    }

    private void consider(IInstallableUnit match) {
        if (this.considered.add(match)) {
            this.toProcess.addLast(match);
        }
    }
}

