/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.rollback;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.p2.director.SimplePlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.query.IQuery;

public class FormerState {
    public static ProfileChangeRequest generateProfileDeltaChangeRequest(IProfile current, IProfile target) {
        ProfileChangeRequest request = new ProfileChangeRequest(current);
        FormerState.synchronizeProfileProperties(request, current, target);
        FormerState.synchronizeMarkedIUs(request, current, target);
        FormerState.synchronizeAllIUProperties(request, current, target);
        return request;
    }

    private static void synchronizeAllIUProperties(ProfileChangeRequest request, IProfile current, IProfile target) {
        IInstallableUnit iu;
        Set currentIUset = current.query((IQuery)InstallableUnitQuery.ANY, null).unmodifiableSet();
        Iterator targetIUs = target.query((IQuery)InstallableUnitQuery.ANY, null).iterator();
        ArrayList<IInstallableUnit> iusToAdd = new ArrayList<IInstallableUnit>();
        ArrayList<IInstallableUnit> iusToUpdate = new ArrayList<IInstallableUnit>();
        while (targetIUs.hasNext()) {
            IInstallableUnit nxt = (IInstallableUnit)targetIUs.next();
            if (currentIUset.contains(nxt)) {
                iusToUpdate.add(nxt);
                continue;
            }
            iusToAdd.add(nxt);
        }
        Iterator iterator = iusToAdd.iterator();
        while (iterator.hasNext()) {
            iu = (IInstallableUnit)iterator.next();
            Iterator iterator2 = target.getInstallableUnitProperties(iu).entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry entry = iterator2.next();
                request.setInstallableUnitProfileProperty(iu, (String)entry.getKey(), (String)entry.getValue());
            }
        }
        iterator = iusToUpdate.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry;
            iu = (IInstallableUnit)iterator.next();
            HashMap propertiesToSet = new HashMap(target.getInstallableUnitProperties(iu));
            Iterator iterator3 = current.getInstallableUnitProperties(iu).entrySet().iterator();
            while (iterator3.hasNext()) {
                entry = iterator3.next();
                String key = (String)entry.getKey();
                String newValue = (String)propertiesToSet.get(key);
                if (newValue == null) {
                    request.removeInstallableUnitProfileProperty(iu, key);
                    continue;
                }
                if (!newValue.equals(entry.getValue())) continue;
                propertiesToSet.remove(key);
            }
            iterator3 = propertiesToSet.entrySet().iterator();
            while (iterator3.hasNext()) {
                entry = iterator3.next();
                request.setInstallableUnitProfileProperty(iu, (String)entry.getKey(), (String)entry.getValue());
            }
        }
    }

    private static void synchronizeMarkedIUs(ProfileChangeRequest request, IProfile current, IProfile target) {
        IInstallableUnit[] currentPlannerMarkedIUs = SimplePlanner.findPlannerMarkedIUs(current);
        IInstallableUnit[] targetPlannerMarkedIUs = SimplePlanner.findPlannerMarkedIUs(target);
        ArrayList<IInstallableUnit> markedIUsToAdd = new ArrayList<IInstallableUnit>(Arrays.asList(targetPlannerMarkedIUs));
        markedIUsToAdd.removeAll(Arrays.asList(currentPlannerMarkedIUs));
        request.addInstallableUnits(markedIUsToAdd);
        ArrayList<IInstallableUnit> markedIUsToRemove = new ArrayList<IInstallableUnit>(Arrays.asList(currentPlannerMarkedIUs));
        markedIUsToRemove.removeAll(Arrays.asList(targetPlannerMarkedIUs));
        request.removeInstallableUnits(markedIUsToRemove);
    }

    private static void synchronizeProfileProperties(ProfileChangeRequest request, IProfile current, IProfile target) {
        Map.Entry entry;
        HashMap profilePropertiesToSet = new HashMap(target.getProperties());
        Iterator iterator = current.getProperties().entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            String key = (String)entry.getKey();
            String newValue = (String)profilePropertiesToSet.get(key);
            if (newValue == null) {
                request.removeProfileProperty(key);
                continue;
            }
            if (!newValue.equals(entry.getValue())) continue;
            profilePropertiesToSet.remove(key);
        }
        iterator = profilePropertiesToSet.entrySet().iterator();
        while (iterator.hasNext()) {
            entry = iterator.next();
            request.setProfileProperty((String)entry.getKey(), (String)entry.getValue());
        }
    }
}

