/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.simpleconfigurator.manipulator;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.equinox.internal.frameworkadmin.equinox.Messages;
import org.eclipse.equinox.internal.frameworkadmin.utils.Utils;
import org.eclipse.equinox.internal.simpleconfigurator.utils.BundleInfo;
import org.osgi.framework.Version;

public class SimpleConfiguratorManipulatorUtils {
    private static final String VERSION_PREFIX = "#version=";
    private static final String VERSION_1 = "1";
    private static final Version OLD_STYLE_SIMPLE_CONFIGURATOR_VERSION = new Version("1.0.100.v20081206");

    public static void writeConfiguration(BundleInfo[] simpleInfos, File outputFile) throws IOException {
        IOException caughtException;
        block23: {
            if (simpleInfos == null || simpleInfos.length == 0) {
                File parentDir;
                if (outputFile.exists()) {
                    outputFile.delete();
                }
                if ((parentDir = outputFile.getParentFile()).exists()) {
                    parentDir.delete();
                }
                return;
            }
            Arrays.sort(simpleInfos, new Comparator(){

                public int compare(Object o1, Object o2) {
                    if (o1 instanceof BundleInfo && o2 instanceof BundleInfo) {
                        return ((BundleInfo)o1).getSymbolicName().compareTo(((BundleInfo)o2).getSymbolicName());
                    }
                    return 0;
                }
            });
            if (!Utils.createParentDir((File)outputFile)) {
                throw new IllegalStateException(Messages.exception_failedToCreateDir);
            }
            BufferedWriter writer = null;
            caughtException = null;
            boolean oldStyle = false;
            int i = 0;
            while (i < simpleInfos.length) {
                if ("org.eclipse.equinox.simpleconfigurator".equals(simpleInfos[i].getSymbolicName())) {
                    Version version = new Version(simpleInfos[i].getVersion());
                    if (version.compareTo((Object)OLD_STYLE_SIMPLE_CONFIGURATOR_VERSION) >= 0) break;
                    oldStyle = true;
                    break;
                }
                ++i;
            }
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(outputFile));
                    writer.write(SimpleConfiguratorManipulatorUtils.createVersionLine());
                    writer.newLine();
                    i = 0;
                    while (i < simpleInfos.length) {
                        writer.write(SimpleConfiguratorManipulatorUtils.createBundleInfoLine(simpleInfos[i], oldStyle));
                        writer.newLine();
                        ++i;
                    }
                }
                catch (IOException e) {
                    caughtException = e;
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e2) {
                            if (caughtException != null) {
                                caughtException = e2;
                            }
                        }
                    }
                    break block23;
                }
            }
            catch (Throwable throwable) {
                block24: {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            if (caughtException == null) break block24;
                            caughtException = e;
                        }
                    }
                }
                throw throwable;
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    if (caughtException == null) break block23;
                    caughtException = e;
                }
            }
        }
        if (caughtException != null) {
            throw caughtException;
        }
    }

    public static String createVersionLine() {
        return "#version=1";
    }

    public static String createBundleInfoLine(BundleInfo bundleInfo, boolean oldStyle) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(bundleInfo.getSymbolicName());
        buffer.append(',');
        buffer.append(bundleInfo.getVersion());
        buffer.append(',');
        buffer.append(SimpleConfiguratorManipulatorUtils.createBundleLocation(bundleInfo.getLocation(), oldStyle));
        buffer.append(',');
        buffer.append(bundleInfo.getStartLevel());
        buffer.append(',');
        buffer.append(bundleInfo.isMarkedAsStarted());
        return buffer.toString();
    }

    public static String createBundleLocation(URI location, boolean oldStyle) {
        if (oldStyle) {
            String scheme = location.getScheme();
            if (scheme == null) {
                scheme = "file";
            }
            return String.valueOf(scheme) + ':' + location.getSchemeSpecificPart();
        }
        String result = location.toString();
        int commaIndex = result.indexOf(44);
        while (commaIndex != -1) {
            result = String.valueOf(result.substring(0, commaIndex)) + "%2C" + result.substring(commaIndex + 1);
            commaIndex = result.indexOf(44);
        }
        return result;
    }
}

