/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.list.WritableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.riena.beans.common.AbstractBean;
import org.eclipse.riena.beans.common.Person;
import org.eclipse.riena.beans.common.PersonFactory;
import org.eclipse.riena.beans.common.TypedBean;
import org.eclipse.riena.core.RienaStatus;
import org.eclipse.riena.internal.ui.ridgets.swt.CComboRidget;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.AbstractMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IBrowserRidget;
import org.eclipse.riena.ui.ridgets.IComboRidget;
import org.eclipse.riena.ui.ridgets.IDateTextRidget;
import org.eclipse.riena.ui.ridgets.IDateTimeRidget;
import org.eclipse.riena.ui.ridgets.ILabelRidget;
import org.eclipse.riena.ui.ridgets.ILinkRidget;
import org.eclipse.riena.ui.ridgets.IListRidget;
import org.eclipse.riena.ui.ridgets.IMasterDetailsDelegate;
import org.eclipse.riena.ui.ridgets.IMasterDetailsRidget;
import org.eclipse.riena.ui.ridgets.IMultipleChoiceRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IRidgetContainer;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.ISingleChoiceRidget;
import org.eclipse.riena.ui.ridgets.ISpinnerRidget;
import org.eclipse.riena.ui.ridgets.ITableRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.ITraverseRidget;
import org.eclipse.riena.ui.ridgets.listener.ISelectionListener;
import org.eclipse.riena.ui.ridgets.listener.SelectionEvent;
import org.eclipse.riena.ui.ridgets.validation.NotEmpty;

public class ControllerTestsPlaygroundSubModuleController
extends SubModuleController {
    private ITableRidget multiTable;
    private IListRidget tableList;
    private Temperature temperature;
    private ITraverseRidget celsiusScale;
    private ISpinnerRidget fahrenheitSpinner;
    private List<Person> input = PersonFactory.createPersonList();
    private long now;

    public ControllerTestsPlaygroundSubModuleController() {
        this.temperature = new Temperature();
        this.temperature.setKelvin(273.15f);
    }

    public void configureRidgets() {
        this.configureTableGroup();
        this.configureComboGroup();
        this.configureBrowserGroup();
        this.configureTraverseGroup();
        this.configureMasterDetailsGroup();
        this.configureDateTimeGroup();
    }

    private void configureDateTimeGroup() {
        final IDateTimeRidget dtDate = (IDateTimeRidget)this.getRidget(IDateTimeRidget.class, "dtDate");
        IDateTimeRidget dtTime = (IDateTimeRidget)this.getRidget(IDateTimeRidget.class, "dtTime");
        final IDateTimeRidget dtDateOnly = (IDateTimeRidget)this.getRidget(IDateTimeRidget.class, "dtDateOnly");
        IDateTimeRidget dtTimeOnly = (IDateTimeRidget)this.getRidget(IDateTimeRidget.class, "dtTimeOnly");
        final IDateTimeRidget dtCal = (IDateTimeRidget)this.getRidget(IDateTimeRidget.class, "dtCal");
        ITextRidget txt1 = (ITextRidget)this.getRidget(ITextRidget.class, "txt1");
        ITextRidget txt2 = (ITextRidget)this.getRidget(ITextRidget.class, "txt2");
        ITextRidget txt3 = (ITextRidget)this.getRidget(ITextRidget.class, "txt3");
        ITextRidget txt4 = (ITextRidget)this.getRidget(ITextRidget.class, "txt4");
        this.now = System.currentTimeMillis();
        TypedBean date1 = new TypedBean((Object)new Date(this.now));
        TypedBean date2 = new TypedBean((Object)new Date(this.now));
        TypedBean date3 = new TypedBean((Object)new Date(this.now));
        TypedBean date4 = new TypedBean((Object)new Date(this.now));
        dtDate.bindToModel((Object)date1, "value");
        dtDate.updateFromModel();
        dtTime.bindToModel((Object)date1, "value");
        dtTime.updateFromModel();
        dtDateOnly.bindToModel((Object)date2, "value");
        dtDateOnly.updateFromModel();
        dtTimeOnly.bindToModel((Object)date3, "value");
        dtTimeOnly.updateFromModel();
        dtCal.bindToModel((Object)date4, "value");
        dtCal.updateFromModel();
        DataBindingContext dbc = new DataBindingContext();
        dbc.bindValue(BeansObservables.observeValue((Object)txt1, (String)"text"), BeansObservables.observeValue((Object)date1, (String)"value"));
        dbc.bindValue(BeansObservables.observeValue((Object)txt2, (String)"text"), BeansObservables.observeValue((Object)date2, (String)"value"));
        dbc.bindValue(BeansObservables.observeValue((Object)txt3, (String)"text"), BeansObservables.observeValue((Object)date3, (String)"value"));
        dbc.bindValue(BeansObservables.observeValue((Object)txt4, (String)"text"), BeansObservables.observeValue((Object)date4, (String)"value"));
        this.makeOutputOnly(txt1, txt2, txt3, txt4);
        final IDateTextRidget dateTextRidget = (IDateTextRidget)this.getRidget(IDateTextRidget.class, "dateText");
        dateTextRidget.setText("03.03.2011");
        IActionRidget dateTimeButton = (IActionRidget)this.getRidget(IActionRidget.class, "dateTimeButton");
        dateTimeButton.setText("apply date");
        dateTimeButton.addListener(new IActionListener(){

            public void callback() {
                SimpleDateFormat df = new SimpleDateFormat("dd.MM.yyyy");
                try {
                    Date newDate = df.parse(dateTextRidget.getText());
                    dtDate.setDate(newDate);
                    dtDateOnly.setDate(newDate);
                    dtCal.setDate(newDate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void configureMasterDetailsGroup() {
        IActionRidget enableDisableButton;
        String[] properties = new String[]{"firstname", "lastname"};
        String[] headers = new String[]{"First Name", "Last Name"};
        final IMasterDetailsRidget master = (IMasterDetailsRidget)this.getRidget(IMasterDetailsRidget.class, "master");
        if (master != null) {
            if (RienaStatus.isTest()) {
                master.configureRidgets();
            }
            master.setDelegate((IMasterDetailsDelegate)new PersonDelegate());
            master.bindToModel((IObservableList)new WritableList(this.input, Person.class), Person.class, properties, headers);
            master.updateFromModel();
            IActionRidget actionApply = (IActionRidget)master.getRidget(IActionRidget.class, "mdApplyButton");
            this.addDefaultAction((IRidget)master, actionApply);
        }
        if ((enableDisableButton = (IActionRidget)this.getRidget(IActionRidget.class, "enableDisable")) != null) {
            enableDisableButton.addListener(new IActionListener(){

                public void callback() {
                    if (master != null) {
                        master.setEnabled(!master.isEnabled());
                    }
                }
            });
        }
    }

    private void configureBrowserGroup() {
        ILinkRidget link1 = (ILinkRidget)this.getRidget(ILinkRidget.class, "link1");
        link1.setText("<a>http://www.eclipse.org/</a>");
        ILinkRidget link2 = (ILinkRidget)this.getRidget(ILinkRidget.class, "link2");
        link2.setText("Visit <a href=\"http://www.eclipse.org/riena/\">Riena</a>");
        ILinkRidget link3 = (ILinkRidget)this.getRidget(ILinkRidget.class, "link3");
        link3.setText("Eclipse <a href=\"http://planeteclipse.org\">Blogs</a>, <a href=\"http://www.eclipse.org/community/news/\">News</a> and <a href=\"http://live.eclipse.org\">Events</a>");
        ITextRidget textLinkUrl = (ITextRidget)this.getRidget(ITextRidget.class, "textLinkUrl");
        textLinkUrl.setOutputOnly(true);
        final IBrowserRidget browser = (IBrowserRidget)this.getRidget(IBrowserRidget.class, "browser");
        browser.bindToModel((Object)textLinkUrl, "text");
        ISelectionListener listener = new ISelectionListener(){

            public void ridgetSelected(SelectionEvent event) {
                String linkUrl = (String)event.getNewSelection().get(0);
                browser.setUrl(linkUrl);
            }
        };
        link1.addSelectionListener(listener);
        link2.addSelectionListener(listener);
        link3.addSelectionListener(listener);
    }

    private void configureComboGroup() {
        final ITextRidget comboText = (ITextRidget)this.getRidget(ITextRidget.class, "comboTextField");
        final ArrayList<String> ages = new ArrayList<String>(Arrays.asList("<none>", "young", "moderate", "aged", "old"));
        final ILabelRidget comboLabel = (ILabelRidget)this.getRidget(ILabelRidget.class, "comboLabel");
        comboLabel.setText((String)ages.get(0));
        final IComboRidget comboAge = (IComboRidget)this.getRidget(IComboRidget.class, "ageCombo");
        comboAge.bindToModel((IObservableList)new WritableList(ages, String.class), String.class, null, (IObservableValue)new WritableValue());
        comboAge.updateFromModel();
        comboAge.setEmptySelectionItem((Object)"<none>");
        comboAge.setSelection(0);
        final IComboRidget cComboAge = (IComboRidget)this.getRidget(CComboRidget.class, "ageCCombo");
        cComboAge.bindToModel((IObservableList)new WritableList(ages, String.class), String.class, null, (IObservableValue)new WritableValue());
        cComboAge.updateFromModel();
        cComboAge.setEmptySelectionItem((Object)"<none>");
        cComboAge.setSelection(0);
        ISelectionListener selectionListener = new ISelectionListener(){

            public void ridgetSelected(SelectionEvent event) {
                comboLabel.setText(event.getNewSelection().get(0).toString());
            }
        };
        comboAge.addSelectionListener(selectionListener);
        cComboAge.addSelectionListener(selectionListener);
        IActionRidget addToComboButton = (IActionRidget)this.getRidget(IActionRidget.class, "addToComboButton");
        addToComboButton.addListener(new IActionListener(){

            public void callback() {
                String comboString = comboText.getText();
                if (comboString.length() >= 0) {
                    ages.add(comboString);
                }
                comboAge.bindToModel((IObservableList)new WritableList(ages, String.class), String.class, null, (IObservableValue)new WritableValue());
                comboAge.updateFromModel();
                comboAge.setSelection(comboAge.getObservableList().size() - 1);
                cComboAge.bindToModel((IObservableList)new WritableList(ages, String.class), String.class, null, (IObservableValue)new WritableValue());
                cComboAge.updateFromModel();
                cComboAge.setSelection(comboAge.getObservableList().size() - 1);
                comboText.setText("");
            }
        });
    }

    private void configureTableGroup() {
        this.multiTable = (ITableRidget)this.getRidget(ITableRidget.class, "multiTable");
        Object[] widths = new ColumnLayoutData[]{new ColumnPixelData(80, true), new ColumnPixelData(80, true)};
        this.multiTable.setColumnWidths(widths);
        this.multiTable.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        String[] colValues = new String[]{"lastname", "firstname"};
        String[] colHeaders = new String[]{"Last Name", "First Name"};
        this.multiTable.bindToModel((IObservableList)this.createPersonList(), Person.class, colValues, colHeaders);
        this.multiTable.updateFromModel();
        this.tableList = (IListRidget)this.getRidget(IListRidget.class, "tableList");
        this.tableList.setSelectionType(ISelectableRidget.SelectionType.MULTI);
        IActionRidget copySelectionButton = (IActionRidget)this.getRidget(IActionRidget.class, "copySelectionButton");
        copySelectionButton.addListener(new IActionListener(){

            public void callback() {
                List selection = ControllerTestsPlaygroundSubModuleController.this.multiTable.getSelection();
                ControllerTestsPlaygroundSubModuleController.this.tableList.bindToModel((IObservableList)new WritableList(selection, Person.class), Person.class, "listEntry");
                ControllerTestsPlaygroundSubModuleController.this.tableList.updateFromModel();
            }
        });
    }

    private void configureTraverseGroup() {
        TemperatureListener listener = new TemperatureListener();
        this.fahrenheitSpinner = (ISpinnerRidget)this.getRidget(ISpinnerRidget.class, "fahrenheitSpinner");
        this.fahrenheitSpinner.setIncrement(1);
        this.fahrenheitSpinner.setMaximum(122);
        this.fahrenheitSpinner.setMinimum(32);
        this.fahrenheitSpinner.bindToModel(BeansObservables.observeValue((Object)((Object)this.temperature), (String)"degreeFahrenheit"));
        this.fahrenheitSpinner.updateFromModel();
        this.fahrenheitSpinner.addListener((IActionListener)listener);
        this.celsiusScale = (ITraverseRidget)this.getRidget(ITraverseRidget.class, "celsiusScale");
        this.celsiusScale.setIncrement(1);
        this.celsiusScale.setMaximum(50);
        this.celsiusScale.setMinimum(0);
        this.celsiusScale.bindToModel(BeansObservables.observeValue((Object)((Object)this.temperature), (String)"degreeCelsius"));
        this.celsiusScale.updateFromModel();
        this.celsiusScale.addListener((IActionListener)listener);
    }

    private WritableList createPersonList() {
        return new WritableList(PersonFactory.createPersonList(), Person.class);
    }

    private void makeOutputOnly(ITextRidget ... ridgets) {
        ITextRidget[] iTextRidgetArray = ridgets;
        int n = ridgets.length;
        int n2 = 0;
        while (n2 < n) {
            ITextRidget ridget = iTextRidgetArray[n2];
            ridget.setOutputOnly(true);
            ++n2;
        }
    }

    private static final class PersonDelegate
    extends AbstractMasterDetailsDelegate {
        private static final String[] GENDER = new String[]{"female", "male"};
        private final Person workingCopy = this.createWorkingCopy();

        private PersonDelegate() {
        }

        public void configureRidgets(IRidgetContainer container) {
            IMultipleChoiceRidget pets;
            ITextRidget txtFirst = (ITextRidget)container.getRidget(ITextRidget.class, "first");
            txtFirst.setMandatory(true);
            txtFirst.bindToModel((Object)this.workingCopy, "firstname");
            txtFirst.updateFromModel();
            ITextRidget txtLast = (ITextRidget)container.getRidget(ITextRidget.class, "last");
            txtLast.setMandatory(true);
            txtLast.addValidationRule((IValidator)new NotEmpty(), ValidationTime.ON_UI_CONTROL_EDIT);
            txtLast.bindToModel((Object)this.workingCopy, "lastname");
            txtLast.updateFromModel();
            ISingleChoiceRidget gender = (ISingleChoiceRidget)container.getRidget(ISingleChoiceRidget.class, "gender");
            if (gender != null) {
                gender.bindToModel(Arrays.asList(GENDER), null, (Object)this.workingCopy, "gender");
                gender.updateFromModel();
            }
            if ((pets = (IMultipleChoiceRidget)container.getRidget(IMultipleChoiceRidget.class, "pets")) != null) {
                pets.bindToModel(Arrays.asList(Person.Pets.values()), null, (Object)this.workingCopy, "pets");
                pets.updateFromModel();
            }
        }

        public Person createWorkingCopy() {
            return new Person("", "");
        }

        public Person copyBean(Object source, Object target) {
            Person from = source != null ? (Person)source : this.createWorkingCopy();
            Person to = target != null ? (Person)target : this.createWorkingCopy();
            to.setFirstname(from.getFirstname());
            to.setLastname(from.getLastname());
            to.setGender(from.getGender());
            to.setPets(from.getPets());
            return to;
        }

        public Object getWorkingCopy() {
            return this.workingCopy;
        }

        public boolean isChanged(Object source, Object target) {
            Person p1 = (Person)source;
            Person p2 = (Person)target;
            boolean equals = p1.getFirstname().equals(p2.getFirstname()) && p1.getLastname().equals(p2.getLastname()) && p1.getGender().equals(p2.getGender()) && p1.getPets().equals(p2.getPets());
            return !equals;
        }

        public String isValid(IRidgetContainer container) {
            ITextRidget txtLast = (ITextRidget)container.getRidget(ITextRidget.class, "last");
            if (txtLast.isErrorMarked()) {
                return "'Last Name' is not valid.";
            }
            return null;
        }
    }

    private class Temperature
    extends AbstractBean {
        static final String PROPERTY_DEGREE_CELSIUS = "degreeCelsius";
        static final String PROPERTY_DEGREE_FAHRENHEITN = "degreeFahrenheit";
        private float kelvin;
        private int degreeCelsius;
        private int degreeFahrenheit;

        public Temperature() {
            this.setDegreeCelsius(0);
        }

        public void setDegreeCelsius(int degreeCelsius) {
            this.setDegreeCelsius(degreeCelsius, true);
        }

        private void setDegreeCelsius(int degreeCelsius, boolean updateKelvin) {
            int oldValue = this.degreeCelsius;
            this.degreeCelsius = degreeCelsius;
            if (updateKelvin) {
                float k = (float)degreeCelsius + 273.15f;
                this.setKelvin(k);
                this.updateFahrenheit();
            }
            this.firePropertyChanged(PROPERTY_DEGREE_CELSIUS, oldValue, degreeCelsius);
        }

        public int getDegreeCelsius() {
            return this.degreeCelsius;
        }

        public void setDegreeFahrenheit(int degreeFahrenheit) {
            this.setDegreeFahrenheit(degreeFahrenheit, true);
        }

        private void setDegreeFahrenheit(int degreeFahrenheit, boolean updateKelvin) {
            int oldValue = this.degreeFahrenheit;
            this.degreeFahrenheit = degreeFahrenheit;
            if (updateKelvin) {
                float c = (float)(degreeFahrenheit - 32) / 1.8f;
                float k = c + 273.15f;
                this.setKelvin(k);
                this.updateCelsius();
            }
            this.firePropertyChanged(PROPERTY_DEGREE_FAHRENHEITN, oldValue, degreeFahrenheit);
        }

        public int getDegreeFahrenheit() {
            return this.degreeFahrenheit;
        }

        private void setKelvin(float kelvin) {
            this.kelvin = kelvin;
        }

        private float getKelvin() {
            return this.kelvin;
        }

        private void updateCelsius() {
            int c = Math.round(this.getKelvin() - 273.15f);
            this.setDegreeCelsius(c, false);
        }

        private void updateFahrenheit() {
            int c = Math.round(this.getKelvin() - 273.15f);
            int f = Math.round((float)c * 1.8f + 32.0f);
            this.setDegreeFahrenheit(f, false);
        }
    }

    private class TemperatureListener
    implements IActionListener {
        private TemperatureListener() {
        }

        public void callback() {
            ControllerTestsPlaygroundSubModuleController.this.celsiusScale.updateFromModel();
            ControllerTestsPlaygroundSubModuleController.this.fahrenheitSpinner.updateFromModel();
        }
    }
}

