/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.example.client.controllers;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.riena.beans.common.IntegerBean;
import org.eclipse.riena.beans.common.TypedBean;
import org.eclipse.riena.navigation.ui.controllers.SubModuleController;
import org.eclipse.riena.ui.core.marker.ValidationTime;
import org.eclipse.riena.ui.ridgets.IDecimalTextRidget;
import org.eclipse.riena.ui.ridgets.INumericTextRidget;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITextRidget;
import org.eclipse.riena.ui.ridgets.validation.MaxNumberLength;
import org.eclipse.riena.ui.ridgets.validation.MinLength;
import org.eclipse.riena.ui.ridgets.validation.ValidRange;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextNumericSubModuleController
extends SubModuleController {
    public void configureRidgets() {
        String[] ids = new String[]{"StringNum", "Integer", "Long", "BigInteger", "StringDec", "Double", "Float", "BigDecimal", "Range", "MaxEight", "MinThree"};
        DataBindingContext dbc = new DataBindingContext();
        String[] stringArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            String id = stringArray[n2];
            this.bind(dbc, id);
            ++n2;
        }
        this.bindToModel("StringNum", new TypedBean((Object)"1234"));
        this.bindToModel("Integer", new TypedBean((Object)-1234), true);
        this.bindToModel("Long", new TypedBean((Object)1234L));
        this.bindToModel("BigInteger", new TypedBean((Object)BigInteger.valueOf(12345789L)));
        IDecimalTextRidget inStringDec = (IDecimalTextRidget)this.getRidget("inStringDec");
        inStringDec.setPrecision(4);
        this.bindToModel("StringDec", new TypedBean((Object)"12345678.1234"));
        this.bindToModel("Double", new TypedBean((Object)-1234.0), true);
        this.bindToModel("Float", new TypedBean((Object)Float.valueOf("1234")));
        IDecimalTextRidget inBigDecimal = (IDecimalTextRidget)this.getRidget("inBigDecimal");
        inBigDecimal.setMaxLength(30);
        inBigDecimal.setPrecision(10);
        this.bindToModel("BigDecimal", new TypedBean((Object)BigDecimal.valueOf(1.23457891234E7)));
        INumericTextRidget txtRange = (INumericTextRidget)this.getRidget("inRange");
        txtRange.addValidationRule((IValidator)new ValidRange((Number)100, (Number)1000), ValidationTime.ON_UPDATE_TO_MODEL);
        txtRange.bindToModel((Object)new IntegerBean(100), "value");
        txtRange.updateFromModel();
        INumericTextRidget txtMaxEight = (INumericTextRidget)this.getRidget("inMaxEight");
        txtMaxEight.addValidationRule((IValidator)new MaxNumberLength(8), ValidationTime.ON_UI_CONTROL_EDIT);
        txtMaxEight.bindToModel((Object)new IntegerBean(123456), "value");
        txtMaxEight.updateFromModel();
        INumericTextRidget txtMinThree = (INumericTextRidget)this.getRidget("inMinThree");
        txtMinThree.setGrouping(false);
        txtMinThree.addValidationRule((IValidator)new MinLength(4), ValidationTime.ON_UI_CONTROL_EDIT);
        txtMinThree.bindToModel((Object)new IntegerBean(1234), "value");
        txtMinThree.updateFromModel();
    }

    private void bind(DataBindingContext dbc, String id) {
        IRidget inputRidget = this.getRidget("in" + id);
        ITextRidget outputRidget = (ITextRidget)this.getRidget("out" + id);
        outputRidget.setOutputOnly(true);
        dbc.bindValue(BeansObservables.observeValue((Object)inputRidget, (String)"text"), BeansObservables.observeValue((Object)outputRidget, (String)"text"), new UpdateValueStrategy(UpdateValueStrategy.POLICY_UPDATE), new UpdateValueStrategy(UpdateValueStrategy.POLICY_NEVER));
    }

    private void bindToModel(String id, TypedBean<?> value, boolean signed) {
        INumericTextRidget inputRidget = (INumericTextRidget)this.getRidget("in" + id);
        inputRidget.setSigned(signed);
        inputRidget.bindToModel(value, "value");
        inputRidget.updateFromModel();
    }

    private void bindToModel(String id, TypedBean<?> value) {
        this.bindToModel(id, value, false);
    }
}

