/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.equinox.internal.p2.core.helpers.CollectionUtils;
import org.eclipse.equinox.internal.p2.metadata.RequiredCapability;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IProvidedCapability;
import org.eclipse.equinox.p2.metadata.IRequirement;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.ql.ICapabilityIndex;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CapabilityIndex
implements ICapabilityIndex {
    private final Map<String, Object> capabilityMap;

    public CapabilityIndex(Iterator<IInstallableUnit> itor) {
        HashMap<String, Object> index = new HashMap<String, Object>(300);
        while (itor.hasNext()) {
            IInstallableUnit iu = itor.next();
            Collection pcs = iu.getProvidedCapabilities();
            for (IProvidedCapability pc : pcs) {
                ArrayList<IInstallableUnit> lst;
                String name = pc.getName();
                Object prev = index.put(name, iu);
                if (prev == null) continue;
                if (prev instanceof ArrayList) {
                    lst = (ArrayList<IInstallableUnit>)prev;
                } else {
                    lst = new ArrayList<IInstallableUnit>(4);
                    lst.add((IInstallableUnit)prev);
                }
                lst.add(iu);
                index.put(name, lst);
            }
        }
        this.capabilityMap = index;
    }

    @Override
    public Iterator<IInstallableUnit> satisfiesAny(Iterator<IRequirement> requirements) {
        if (!requirements.hasNext()) {
            return CollectionUtils.emptyList().iterator();
        }
        ArrayList<IInstallableUnit> collector = new ArrayList<IInstallableUnit>();
        do {
            IRequirement nxt = requirements.next();
            this.collectMatchingIUs(nxt, collector);
        } while (requirements.hasNext());
        return collector.iterator();
    }

    @Override
    public Iterator<IInstallableUnit> satisfiesAll(Iterator<IRequirement> requirements) {
        if (!requirements.hasNext()) {
            return CollectionUtils.emptyList().iterator();
        }
        Set<IInstallableUnit> collector = new HashSet<IInstallableUnit>();
        this.collectMatchingIUs(requirements.next(), collector);
        while (requirements.hasNext() && !collector.isEmpty()) {
            collector = this.retainMatchingIUs(requirements.next(), collector);
        }
        return collector.iterator();
    }

    private void collectMatchingIUs(IRequirement requirement, Collection<IInstallableUnit> collector) {
        IMatchExpression matches = requirement.getMatches();
        String name = RequiredCapability.extractName((IMatchExpression)matches);
        Object v = this.capabilityMap.get(name);
        if (v == null) {
            return;
        }
        IEvaluationContext ctx = matches.createContext();
        if (v instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)v;
            if (matches.isMatch(ctx, (Object)iu)) {
                collector.add(iu);
            }
        } else {
            List ius = (List)v;
            int idx = ius.size();
            while (--idx >= 0) {
                IInstallableUnit iu = (IInstallableUnit)ius.get(idx);
                if (!matches.isMatch(ctx, (Object)iu)) continue;
                collector.add(iu);
            }
        }
    }

    private Set<IInstallableUnit> retainMatchingIUs(IRequirement requirement, Set<IInstallableUnit> collector) {
        IMatchExpression matches = requirement.getMatches();
        String name = RequiredCapability.extractName((IMatchExpression)matches);
        Object v = this.capabilityMap.get(name);
        if (v == null) {
            return CollectionUtils.emptySet();
        }
        IEvaluationContext ctx = matches.createContext();
        HashSet<IInstallableUnit> retained = null;
        if (v instanceof IInstallableUnit) {
            IInstallableUnit iu = (IInstallableUnit)v;
            if (matches.isMatch(ctx, (Object)iu) && collector.contains(iu)) {
                if (retained == null) {
                    retained = new HashSet<IInstallableUnit>();
                }
                retained.add(iu);
            }
        } else {
            List ius = (List)v;
            int idx = ius.size();
            while (--idx >= 0) {
                IInstallableUnit iu = (IInstallableUnit)ius.get(idx);
                if (!matches.isMatch(ctx, (Object)iu) || !collector.contains(iu)) continue;
                if (retained == null) {
                    retained = new HashSet();
                }
                retained.add(iu);
            }
        }
        return retained == null ? CollectionUtils.emptySet() : retained;
    }
}

