/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.metadata.expression.IRepeatableIterator;
import org.eclipse.equinox.internal.p2.metadata.expression.RepeatableIterator;
import org.eclipse.equinox.internal.p2.ql.TranslationSupport;
import org.eclipse.equinox.p2.ql.IQueryContext;
import org.eclipse.equinox.p2.ql.ITranslationSupport;
import org.eclipse.equinox.p2.query.ContextQuery;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.osgi.service.localization.LocaleProvider;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryContext<T>
implements IQueryContext<T> {
    private final IQueryable<T> queryable;
    private Map<Locale, TranslationSupport> translationSupports;

    public QueryContext(IQueryable<T> queryable) {
        this.queryable = queryable;
    }

    public QueryContext(Iterator<T> iterator) {
        final IRepeatableIterator repeatable = RepeatableIterator.create(iterator);
        this.queryable = new IQueryable<T>(){

            public IQueryResult<T> query(IQuery<T> query, IProgressMonitor monitor) {
                return query.perform((Iterator)repeatable.getCopy());
            }
        };
    }

    @Override
    public synchronized ITranslationSupport getTranslationSupport(final Locale locale) {
        TranslationSupport ts;
        if (this.translationSupports == null) {
            this.translationSupports = new HashMap<Locale, TranslationSupport>();
        }
        if ((ts = this.translationSupports.get(locale)) == null) {
            ts = new TranslationSupport();
            ts.setTranslationSource(this.queryable);
            ts.setLocaleProvider(new LocaleProvider(){

                public Locale getLocale() {
                    return locale;
                }
            });
            this.translationSupports.put(locale, ts);
        }
        return ts;
    }

    @Override
    public Iterator<T> iterator() {
        final Iterator[] iteratorCatcher = new Iterator[1];
        this.queryable.query((IQuery)new ContextQuery<T>(){

            public IQueryResult<T> perform(Iterator<T> iterator) {
                iteratorCatcher[0] = iterator;
                return null;
            }
        }, (IProgressMonitor)new NullProgressMonitor());
        return iteratorCatcher[0];
    }
}

