/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql.expression;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.NAry;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.internal.p2.ql.expression.IQLConstants;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.ql.IQLExpression;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class Array
extends NAry
implements IQLConstants,
IQLExpression {
    Array(Expression[] operands) {
        super(Array.assertLength((Expression[])operands, (int)0, (String)"[]"));
    }

    public Object evaluate(IEvaluationContext context) {
        return this.evaluateAsIterator(context);
    }

    public Iterator<?> evaluateAsIterator(IEvaluationContext context) {
        return new ArrayIterator(context);
    }

    public int getExpressionType() {
        return 20;
    }

    public void toString(StringBuffer bld, Variable rootVariable) {
        bld.append('[');
        Array.elementsToString((StringBuffer)bld, (Variable)rootVariable, (Expression[])this.operands);
        bld.append(']');
    }

    public String getOperator() {
        return "[]";
    }

    public int getPriority() {
        return 2;
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class ArrayIterator
    implements Iterator<Object> {
        private final IEvaluationContext context;
        private int pos = -1;

        public ArrayIterator(IEvaluationContext context) {
            this.context = context;
        }

        @Override
        public boolean hasNext() {
            return this.pos + 1 < Array.this.operands.length;
        }

        @Override
        public Object next() {
            if (++this.pos >= Array.this.operands.length) {
                --this.pos;
                throw new NoSuchElementException();
            }
            return Array.this.operands[this.pos].evaluate(this.context);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

