/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql.expression;

import java.util.Iterator;
import org.eclipse.equinox.internal.p2.metadata.expression.EvaluationContext;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.Unary;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.internal.p2.ql.Everything;
import org.eclipse.equinox.internal.p2.ql.expression.IQLConstants;
import org.eclipse.equinox.internal.p2.ql.expression.QLFactory;
import org.eclipse.equinox.internal.p2.ql.expression.QLUtil;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionVisitor;
import org.eclipse.equinox.p2.ql.IContextExpression;
import org.eclipse.equinox.p2.ql.ITranslationSupport;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ContextExpression<T>
extends Unary
implements IContextExpression<T>,
IQLConstants {
    private static final Object[] noParams = new Object[0];
    private final Class<T> elementClass;
    private final Object[] parameters;

    public ContextExpression(Class<T> elementClass, Expression expression, Object[] parameters) {
        super(expression);
        this.elementClass = elementClass;
        this.parameters = parameters == null ? noParams : parameters;
    }

    public boolean accept(IExpressionVisitor visitor) {
        return visitor.visit((IExpression)this.operand);
    }

    public void toString(StringBuffer bld, Variable rootVariable) {
        this.operand.toString(bld, rootVariable);
    }

    @Override
    public IEvaluationContext createContext(Iterator<T> iterator) {
        Variable everything = QLFactory.EVERYTHING;
        IEvaluationContext context = EvaluationContext.create((Object[])this.parameters, (IExpression)everything);
        context.setValue((IExpression)everything, new Everything<T>(this.elementClass, iterator, QLUtil.needsRepeadedAccessToEverything(this.operand)));
        return context;
    }

    @Override
    public IEvaluationContext createContext(Iterator<T> iterator, ITranslationSupport ts) {
        Variable everything = QLFactory.EVERYTHING;
        Variable translations = QLFactory.TRANSLATIONS;
        IEvaluationContext context = EvaluationContext.create((Object[])this.parameters, (IExpression[])new IExpression[]{everything, translations});
        context.setValue((IExpression)everything, new Everything<T>(this.elementClass, iterator, QLUtil.needsRepeadedAccessToEverything(this.operand)));
        context.setValue((IExpression)translations, (Object)ts);
        return context;
    }

    @Override
    public Class<T> getElementClass() {
        return this.elementClass;
    }

    public int getExpressionType() {
        return 0;
    }

    public String getOperator() {
        throw new UnsupportedOperationException();
    }

    public int getPriority() {
        return this.operand.getPriority();
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    public int hashCode() {
        return this.operand.hashCode();
    }

    @Override
    public Iterator<T> iterator(IEvaluationContext context) {
        return this.evaluateAsIterator(context);
    }

    public void toString(StringBuffer bld) {
        this.toString(bld, QLFactory.EVERYTHING);
    }
}

