/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql.expression;

import org.eclipse.equinox.internal.p2.metadata.expression.EvaluationContext;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.LambdaExpression;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.internal.p2.ql.expression.Assignment;
import org.eclipse.equinox.internal.p2.ql.expression.IQLConstants;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionVisitor;
import org.eclipse.equinox.p2.ql.IQLExpression;

final class CurryedLambdaExpression
extends LambdaExpression
implements IQLConstants,
IQLExpression {
    private static final Assignment[] emptyAssignmentArray = new Assignment[0];
    private final Assignment[] assignments;

    CurryedLambdaExpression(Variable each, Assignment[] assignments, Expression body) {
        super(each, body);
        if (assignments == null) {
            assignments = emptyAssignmentArray;
        }
        this.assignments = assignments;
    }

    public boolean accept(IExpressionVisitor visitor) {
        if (super.accept(visitor) && this.each.accept(visitor)) {
            int idx = 0;
            while (idx < this.assignments.length) {
                if (!this.assignments[idx].accept(visitor)) {
                    return false;
                }
                ++idx;
            }
            return true;
        }
        return false;
    }

    public int compareTo(Expression e) {
        int cmp = super.compareTo(e);
        if (cmp == 0) {
            cmp = CurryedLambdaExpression.compare((Expression[])this.assignments, (Expression[])((CurryedLambdaExpression)e).assignments);
        }
        return cmp;
    }

    public boolean equals(Object o) {
        return super.equals(o) && CurryedLambdaExpression.equals((Expression[])this.assignments, (Expression[])((CurryedLambdaExpression)o).assignments);
    }

    public int hashCode() {
        return 31 * super.hashCode() + CurryedLambdaExpression.hashCode((Expression[])this.assignments);
    }

    public void toString(StringBuffer bld, Variable rootVariable) {
        int top = this.assignments.length;
        if (top > 0) {
            int idx = 0;
            while (idx < top) {
                CurryedLambdaExpression.appendOperand((StringBuffer)bld, (Variable)rootVariable, (Expression)this.assignments[idx].rhs, (int)12);
                bld.append(", ");
                ++idx;
            }
            bld.append("_");
            bld.append(", {");
            idx = 0;
            while (idx < top) {
                CurryedLambdaExpression.appendOperand((StringBuffer)bld, (Variable)rootVariable, (Expression)this.assignments[idx].lhs, (int)12);
                bld.append(", ");
                ++idx;
            }
        }
        super.toString(bld, rootVariable);
        if (top > 0) {
            bld.append('}');
        }
    }

    public IEvaluationContext prolog(IEvaluationContext context) {
        int top = this.assignments.length + 1;
        Variable[] vars = new Variable[top];
        vars[0] = this.getItemVariable();
        int idx = 1;
        while (idx < top) {
            vars[idx] = (Variable)this.assignments[idx - 1].lhs;
            ++idx;
        }
        IEvaluationContext lambdaContext = EvaluationContext.create((IEvaluationContext)context, (IExpression[])vars);
        idx = 1;
        while (idx < top) {
            lambdaContext.setValue((IExpression)vars[idx], this.assignments[idx - 1].rhs.evaluate(context));
            ++idx;
        }
        return lambdaContext;
    }
}

