/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ql.expression;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.equinox.internal.p2.metadata.expression.Expression;
import org.eclipse.equinox.internal.p2.metadata.expression.IRepeatableIterator;
import org.eclipse.equinox.internal.p2.metadata.expression.RepeatableIterator;
import org.eclipse.equinox.internal.p2.ql.expression.IQLConstants;
import org.eclipse.equinox.internal.p2.ql.expression.QLFactory;
import org.eclipse.equinox.p2.metadata.expression.ExpressionUtil;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IExpressionVisitor;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QLUtil
implements IExpression,
IQLConstants {
    static Set<?> asSet(Object val, boolean forcePrivateCopy) {
        HashSet result;
        if (val == null) {
            throw new IllegalArgumentException("Cannot convert null into an set");
        }
        if (val instanceof IRepeatableIterator) {
            Object provider = ((IRepeatableIterator)val).getIteratorProvider();
            if (!forcePrivateCopy) {
                if (provider instanceof Set) {
                    return (Set)provider;
                }
                if (provider instanceof IQueryResult) {
                    return ((IQueryResult)provider).unmodifiableSet();
                }
            }
            if (provider instanceof Collection) {
                val = provider;
            }
        } else if (!forcePrivateCopy) {
            if (val instanceof Set) {
                return (Set)val;
            }
            if (val instanceof IQueryResult) {
                return ((IQueryResult)val).unmodifiableSet();
            }
        }
        if (val instanceof Collection) {
            result = new HashSet((Collection)val);
        } else {
            result = new HashSet();
            IRepeatableIterator iterator = RepeatableIterator.create((Object)val);
            while (iterator.hasNext()) {
                result.add(iterator.next());
            }
        }
        return result;
    }

    public static boolean needsTranslationSupport(IExpression expression) {
        final boolean[] translationSupportNeeded = new boolean[1];
        ((Expression)expression).accept(new IExpressionVisitor(){

            public boolean visit(IExpression expr) {
                if (expr.getExpressionType() == 13 && "translations".equals(ExpressionUtil.getName((IExpression)expr))) {
                    translationSupportNeeded[0] = true;
                    return false;
                }
                return true;
            }
        });
        return translationSupportNeeded[0];
    }

    static boolean needsRepeadedAccessToEverything(Expression expression) {
        final boolean[] repeatedAccessNeeded = new boolean[1];
        expression.accept(new IExpressionVisitor(){

            public boolean visit(IExpression expr) {
                if (expr == QLFactory.EVERYTHING) {
                    repeatedAccessNeeded[0] = true;
                    return false;
                }
                return true;
            }
        });
        return true;
    }
}

