/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.ql;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.metadata.expression.EvaluationContext;
import org.eclipse.equinox.internal.p2.metadata.expression.Variable;
import org.eclipse.equinox.internal.p2.ql.expression.QLFactory;
import org.eclipse.equinox.internal.p2.ql.expression.QLUtil;
import org.eclipse.equinox.p2.metadata.expression.IEvaluationContext;
import org.eclipse.equinox.p2.metadata.expression.IExpression;
import org.eclipse.equinox.p2.metadata.expression.IMatchExpression;
import org.eclipse.equinox.p2.ql.IQueryContext;
import org.eclipse.equinox.p2.ql.QL;
import org.eclipse.equinox.p2.ql.QLQuery;
import org.eclipse.equinox.p2.ql.QueryResult;
import org.eclipse.equinox.p2.query.IMatchQuery;
import org.eclipse.equinox.p2.query.IQueryResult;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QLMatchQuery<T>
extends QLQuery<T>
implements IMatchQuery<T> {
    private final IMatchExpression<T> expression;
    private IEvaluationContext context;

    public QLMatchQuery(Class<T> instanceClass, IMatchExpression<T> expression) {
        super(instanceClass);
        this.expression = expression;
    }

    public QLMatchQuery(Class<T> instanceClass, String expression, Object[] parameters) {
        this(instanceClass, QL.getFactory().matchExpression(parser.parse(expression), parameters));
    }

    public boolean isMatch(T candidate) {
        return this.elementClass.isInstance(candidate) && this.expression.isMatch(this.context, candidate);
    }

    public void postPerform() {
        this.context = null;
    }

    public void prePerform() {
    }

    public IQueryResult<T> perform(Iterator<T> iterator) {
        if (QLUtil.needsTranslationSupport(this.expression)) {
            IQueryContext<T> queryContext = QL.newQueryContext(iterator);
            Variable translations = QLFactory.TRANSLATIONS;
            this.context = EvaluationContext.create((IEvaluationContext)this.expression.createContext(), (IExpression)translations);
            this.context.setValue((IExpression)translations, (Object)queryContext.getTranslationSupport(this.getLocale()));
        } else {
            this.context = this.expression.createContext();
        }
        this.prePerform();
        try {
            ArrayList<T> result = new ArrayList<T>();
            while (iterator.hasNext()) {
                T candidate = iterator.next();
                if (!this.isMatch(candidate)) continue;
                result.add(candidate);
            }
            QueryResult queryResult = new QueryResult(result);
            return queryResult;
        }
        finally {
            this.postPerform();
        }
    }
}

