/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.metadata.query.PatchQuery;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;

public class InstallOperation
extends ProfileChangeOperation {
    private IInstallableUnit[] toInstall;

    public InstallOperation(ProvisioningSession session, IInstallableUnit[] toInstall) {
        super(session);
        this.toInstall = toInstall;
    }

    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        this.request = ProfileChangeRequest.createByProfileId((String)this.profileId);
        IProfile profile = this.session.getProfileRegistry().getProfile(this.profileId);
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.InstallOperation_ComputeProfileChangeProgress, (int)this.toInstall.length);
        int i = 0;
        while (i < this.toInstall.length) {
            IQueryResult alreadyInstalled;
            if (PatchQuery.isPatch((IInstallableUnit)this.toInstall[i])) {
                this.request.setInstallableUnitInclusionRules(this.toInstall[i], PlannerHelper.createOptionalInclusionRule((IInstallableUnit)this.toInstall[i]));
            }
            if (!(alreadyInstalled = profile.query((IQuery)new InstallableUnitQuery(this.toInstall[i].getId()), null)).isEmpty()) {
                IInstallableUnit installedIU = (IInstallableUnit)alreadyInstalled.iterator().next();
                int compareTo = this.toInstall[i].getVersion().compareTo((Object)installedIU.getVersion());
                if (compareTo > 0) {
                    boolean lockedForUpdate = false;
                    String value = profile.getInstallableUnitProperty(installedIU, "org.eclipse.equinox.p2.type.lock");
                    if (value != null) {
                        boolean bl = lockedForUpdate = (Integer.parseInt(value) & 2) == 2;
                    }
                    if (lockedForUpdate) {
                        status.merge(PlanAnalyzer.getStatus(10013, this.toInstall[i]));
                    } else {
                        this.request.addInstallableUnits(new IInstallableUnit[]{this.toInstall[i]});
                        this.request.removeInstallableUnit(installedIU);
                        status.merge(PlanAnalyzer.getStatus(10003, this.toInstall[i]));
                        if (!UserVisibleRootQuery.isUserVisible((IInstallableUnit)installedIU, (IProfile)profile)) {
                            this.request.setInstallableUnitProfileProperty(this.toInstall[i], "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
                        }
                    }
                } else if (compareTo < 0) {
                    status.merge(PlanAnalyzer.getStatus(10004, this.toInstall[i]));
                } else if (UserVisibleRootQuery.isUserVisible((IInstallableUnit)installedIU, (IProfile)profile)) {
                    status.merge(PlanAnalyzer.getStatus(10005, this.toInstall[i]));
                } else {
                    status.merge(PlanAnalyzer.getStatus(10006, this.toInstall[i]));
                    this.request.setInstallableUnitProfileProperty(this.toInstall[i], "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
                }
            } else {
                this.request.addInstallableUnits(new IInstallableUnit[]{this.toInstall[i]});
                this.request.setInstallableUnitProfileProperty(this.toInstall[i], "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
            }
            sub.worked(1);
            ++i;
        }
        sub.done();
    }

    protected String getResolveJobName() {
        return Messages.InstallOperation_ResolveJobName;
    }

    protected String getProvisioningJobName() {
        return Messages.InstallOperation_InstallJobName;
    }
}

