/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.equinox.internal.p2.core.helpers.ServiceHelper;
import org.eclipse.equinox.internal.p2.operations.Activator;
import org.eclipse.equinox.internal.p2.operations.DownloadPhaseSet;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.SizingPhaseSet;
import org.eclipse.equinox.internal.provisional.configurator.Configurator;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.director.IPlanner;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.engine.DefaultPhaseSet;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IPhaseSet;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.engine.IProvisioningPlan;
import org.eclipse.equinox.p2.engine.ProvisioningContext;
import org.eclipse.equinox.p2.engine.query.UserVisibleRootQuery;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.operations.IProfileChangeJob;
import org.eclipse.equinox.p2.query.CompoundQueryable;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.osgi.framework.BundleContext;

public class ProvisioningSession {
    private IProvisioningAgent agent;
    private Set<Job> scheduledJobs = Collections.synchronizedSet(new HashSet());
    public static final long SIZE_NOTAPPLICABLE = -3L;
    public static final long SIZE_UNAVAILABLE = -2L;
    public static final long SIZE_UNKNOWN = -1L;
    public static final int STATUS_NOTHING_TO_UPDATE = 10000;
    public static final int STATUS_INVALID_REPOSITORY_LOCATION = 10100;

    public ProvisioningSession(IProvisioningAgent agent) {
        Assert.isNotNull((Object)agent, (String)Messages.ProvisioningSession_AgentNotFound);
        this.agent = agent;
    }

    public IProvisioningAgent getProvisioningAgent() {
        return this.agent;
    }

    public IAgentLocation getAgentLocation() {
        return (IAgentLocation)this.agent.getService(IAgentLocation.SERVICE_NAME);
    }

    public IArtifactRepositoryManager getArtifactRepositoryManager() {
        return (IArtifactRepositoryManager)this.agent.getService(IArtifactRepositoryManager.SERVICE_NAME);
    }

    public IMetadataRepositoryManager getMetadataRepositoryManager() {
        return (IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME);
    }

    public IProfileRegistry getProfileRegistry() {
        return (IProfileRegistry)this.agent.getService(IProfileRegistry.SERVICE_NAME);
    }

    public IEngine getEngine() {
        return (IEngine)this.agent.getService(IEngine.SERVICE_NAME);
    }

    public IProvisioningEventBus getProvisioningEventBus() {
        return (IProvisioningEventBus)this.agent.getService(IProvisioningEventBus.SERVICE_NAME);
    }

    public IPlanner getPlanner() {
        return (IPlanner)this.agent.getService(IPlanner.SERVICE_NAME);
    }

    public long getSize(IProvisioningPlan plan, ProvisioningContext context, IProgressMonitor monitor) {
        IStatus status;
        SizingPhaseSet set;
        if (plan == null) {
            return -3L;
        }
        if (this.countPlanElements(plan) == 0) {
            return 0L;
        }
        long installPlanSize = 0L;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)300);
        if (plan.getInstallerPlan() != null) {
            set = new SizingPhaseSet();
            status = this.getEngine().perform(plan.getInstallerPlan(), (IPhaseSet)set, (IProgressMonitor)mon.newChild(100));
            if (status.isOK()) {
                installPlanSize = set.getSizing().getDiskSize();
            }
        } else {
            mon.worked(100);
        }
        set = new SizingPhaseSet();
        status = this.getEngine().perform(plan, (IPhaseSet)set, (IProgressMonitor)mon.newChild(200));
        if (status.isOK()) {
            return installPlanSize + set.getSizing().getDiskSize();
        }
        return -2L;
    }

    private int countPlanElements(IProvisioningPlan plan) {
        return new CompoundQueryable(plan.getAdditions(), plan.getRemovals()).query((IQuery)InstallableUnitQuery.ANY, null).unmodifiableSet().size();
    }

    public IStatus performProvisioningPlan(IProvisioningPlan plan, IPhaseSet phaseSet, ProvisioningContext context, IProgressMonitor monitor) {
        Object set = phaseSet == null ? new DefaultPhaseSet() : phaseSet;
        SubMonitor mon = SubMonitor.convert((IProgressMonitor)monitor, (int)600);
        int ticksUsed = 0;
        IProfile profile = plan.getProfile();
        if (plan.getInstallerPlan() != null) {
            Class<?> clazz;
            IStatus installerPlanStatus;
            if (set instanceof DefaultPhaseSet) {
                ProfileChangeRequest downloadRequest = new ProfileChangeRequest(profile);
                downloadRequest.setAbsoluteMode(true);
                downloadRequest.addInstallableUnits(new CompoundQueryable(plan.getAdditions(), plan.getInstallerPlan().getAdditions()).query((IQuery)InstallableUnitQuery.ANY, null));
                DownloadPhaseSet download = new DownloadPhaseSet();
                IProvisioningPlan downloadPlan = this.getPlanner().getProvisioningPlan(downloadRequest, context, (IProgressMonitor)mon.newChild(100));
                IStatus downloadStatus = this.getEngine().perform(downloadPlan, (IPhaseSet)download, (IProgressMonitor)mon.newChild(300));
                if (!downloadStatus.isOK()) {
                    mon.done();
                    return downloadStatus;
                }
                ticksUsed = 300;
            }
            if (!(installerPlanStatus = this.getEngine().perform(plan.getInstallerPlan(), set, (IProgressMonitor)mon.newChild(100))).isOK()) {
                mon.done();
                return installerPlanStatus;
            }
            ticksUsed += 100;
            try {
                clazz = Class.forName("org.eclipse.equinox.internal.provisional.configurator.Configurator");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
            Configurator configChanger = (Configurator)ServiceHelper.getService((BundleContext)Activator.getContext(), (String)clazz.getName());
            try {
                configChanger.applyConfiguration();
            }
            catch (IOException e) {
                mon.done();
                return new Status(4, "org.eclipse.equinox.p2.operations", Messages.ProvisioningSession_InstallPlanConfigurationError, (Throwable)e);
            }
        }
        return this.getEngine().perform(plan, set, (IProgressMonitor)mon.newChild(500 - ticksUsed));
    }

    public boolean hasScheduledOperationsFor(String profileId) {
        Job[] jobs = this.getScheduledJobs();
        int i = 0;
        while (i < jobs.length) {
            String id;
            if (jobs[i] instanceof IProfileChangeJob && profileId.equals(id = ((IProfileChangeJob)jobs[i]).getProfileId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Job[] getScheduledJobs() {
        Set<Job> set = this.scheduledJobs;
        synchronized (set) {
            return this.scheduledJobs.toArray(new Job[this.scheduledJobs.size()]);
        }
    }

    public void rememberJob(Job job) {
        this.scheduledJobs.add(job);
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ProvisioningSession.this.scheduledJobs.remove(event.getJob());
            }
        });
    }

    public IInstallableUnit[] getInstalledIUs(String profileId, boolean all) {
        Class<?> clazz;
        IProfile profile = this.getProfileRegistry().getProfile(profileId);
        if (profile == null) {
            return new IInstallableUnit[0];
        }
        Object query = all ? InstallableUnitQuery.ANY : new UserVisibleRootQuery();
        IQueryResult queryResult = profile.query((IQuery)query, null);
        try {
            clazz = Class.forName("org.eclipse.equinox.p2.metadata.IInstallableUnit");
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
        return (IInstallableUnit[])queryResult.toArray(clazz);
    }
}

