/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.operations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.equinox.internal.p2.operations.Messages;
import org.eclipse.equinox.internal.p2.operations.PlanAnalyzer;
import org.eclipse.equinox.internal.provisional.p2.director.PlannerHelper;
import org.eclipse.equinox.internal.provisional.p2.director.ProfileChangeRequest;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.IVersionedId;
import org.eclipse.equinox.p2.metadata.query.InstallableUnitQuery;
import org.eclipse.equinox.p2.metadata.query.PatchQuery;
import org.eclipse.equinox.p2.operations.ProfileChangeOperation;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.Update;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;

public class UpdateOperation
extends ProfileChangeOperation {
    private IInstallableUnit[] iusToUpdate;
    private HashMap<IInstallableUnit, List<Update>> possibleUpdatesByIU = new HashMap();
    private List<Update> defaultUpdates;

    public UpdateOperation(ProvisioningSession session, IInstallableUnit[] toBeUpdated) {
        super(session);
        this.iusToUpdate = toBeUpdated;
    }

    public UpdateOperation(ProvisioningSession session) {
        this(session, null);
    }

    public void setSelectedUpdates(Update[] defaultUpdates) {
        this.defaultUpdates = new ArrayList<Update>(Arrays.asList(defaultUpdates));
    }

    public Update[] getSelectedUpdates() {
        if (this.defaultUpdates == null) {
            return new Update[0];
        }
        return this.defaultUpdates.toArray(new Update[this.defaultUpdates.size()]);
    }

    public Update[] getPossibleUpdates() {
        ArrayList<Update> all = new ArrayList<Update>();
        Iterator<List<Update>> iterator = this.possibleUpdatesByIU.values().iterator();
        while (iterator.hasNext()) {
            List<Update> updates = iterator.next();
            all.addAll(updates);
        }
        return all.toArray(new Update[all.size()]);
    }

    private Update[] updatesFor(IInstallableUnit iu, IProfile profile, IProgressMonitor monitor) {
        List<Update> updates;
        if (this.possibleUpdatesByIU.containsKey(iu)) {
            updates = this.possibleUpdatesByIU.get(iu);
        } else {
            IInstallableUnit[] replacements = this.session.getPlanner().updatesFor(iu, this.context, monitor);
            updates = new ArrayList<Update>(replacements.length);
            int i = 0;
            while (i < replacements.length) {
                IQueryResult alreadyInstalled = profile.query((IQuery)new InstallableUnitQuery((IVersionedId)replacements[i]), null);
                if (alreadyInstalled.isEmpty()) {
                    Update update = new Update(iu, replacements[i]);
                    updates.add(update);
                }
                ++i;
            }
            this.possibleUpdatesByIU.put(iu, updates);
        }
        return updates.toArray(new Update[updates.size()]);
    }

    protected void computeProfileChangeRequest(MultiStatus status, IProgressMonitor monitor) {
        HashSet<IInstallableUnit> toBeUpdated = new HashSet<IInstallableUnit>();
        HashSet<Update> elementsToPlan = new HashSet<Update>();
        boolean selectionSpecified = this.defaultUpdates != null;
        IProfile profile = this.session.getProfileRegistry().getProfile(this.profileId);
        if (profile == null) {
            return;
        }
        SubMonitor sub = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.UpdateOperation_ProfileChangeRequestProgress, (int)(100 * this.iusToUpdate.length));
        int i = 0;
        while (i < this.iusToUpdate.length) {
            SubMonitor iuMon = sub.newChild(100);
            Update[] updates = this.updatesFor(this.iusToUpdate[i], profile, (IProgressMonitor)iuMon);
            int j = 0;
            while (j < updates.length) {
                toBeUpdated.add(this.iusToUpdate[i]);
                if (this.defaultUpdates != null && this.defaultUpdates.contains(updates[j])) {
                    elementsToPlan.add(updates[j]);
                }
                ++j;
            }
            if (!selectionSpecified) {
                HashMap<String, Update> latestVersions = new HashMap<String, Update>();
                boolean foundUpdate = false;
                boolean foundPatch = false;
                int j2 = 0;
                while (j2 < updates.length) {
                    IInstallableUnit latestIU;
                    String key;
                    if (PatchQuery.isPatch((IInstallableUnit)updates[j2].replacement)) {
                        foundPatch = true;
                        key = updates[j2].replacement.getId();
                    } else {
                        foundUpdate = true;
                        key = updates[j2].toUpdate.getId();
                    }
                    Update latestUpdate = (Update)latestVersions.get(key);
                    IInstallableUnit iInstallableUnit = latestIU = latestUpdate == null ? null : latestUpdate.replacement;
                    if (latestIU == null || updates[j2].replacement.getVersion().compareTo((Object)latestIU.getVersion()) > 0) {
                        latestVersions.put(key, updates[j2]);
                    }
                    ++j2;
                }
                if (foundPatch && foundUpdate) {
                    HashSet keys = new HashSet();
                    keys.addAll(latestVersions.keySet());
                    Iterator iterator = keys.iterator();
                    while (iterator.hasNext()) {
                        String id = (String)iterator.next();
                        if (id.equals(this.iusToUpdate[i].getId())) continue;
                        latestVersions.remove(id);
                    }
                }
                elementsToPlan.addAll(latestVersions.values());
            }
            sub.worked(100);
            ++i;
        }
        if (toBeUpdated.size() <= 0 || elementsToPlan.isEmpty()) {
            sub.done();
            status.add(PlanAnalyzer.getStatus(10000, null));
            return;
        }
        this.request = ProfileChangeRequest.createByProfileId((String)this.profileId);
        Iterator iterator = elementsToPlan.iterator();
        while (iterator.hasNext()) {
            Update update = (Update)iterator.next();
            IInstallableUnit theUpdate = update.replacement;
            if (this.defaultUpdates == null) {
                this.defaultUpdates = new ArrayList<Update>();
                this.defaultUpdates.add(update);
            } else if (!this.defaultUpdates.contains(update)) {
                this.defaultUpdates.add(update);
            }
            this.request.addInstallableUnits(new IInstallableUnit[]{theUpdate});
            this.request.setInstallableUnitProfileProperty(theUpdate, "org.eclipse.equinox.p2.type.root", Boolean.toString(true));
            if (PatchQuery.isPatch((IInstallableUnit)theUpdate)) {
                this.request.setInstallableUnitInclusionRules(theUpdate, PlannerHelper.createOptionalInclusionRule((IInstallableUnit)theUpdate));
                continue;
            }
            this.request.removeInstallableUnit(update.toUpdate);
        }
        sub.done();
    }

    protected String getProvisioningJobName() {
        return Messages.UpdateOperation_UpdateJobName;
    }

    protected String getResolveJobName() {
        return Messages.UpdateOperation_ResolveJobName;
    }

    protected void prepareToResolve() {
        super.prepareToResolve();
        if (this.iusToUpdate == null) {
            this.iusToUpdate = this.session.getInstalledIUs(this.profileId, false);
        }
    }
}

