/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.garbagecollector;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.repository.artifact.ArtifactKeyQuery;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;

public class CoreGarbageCollector {
    private static boolean debugMode = false;

    public synchronized void clean(IArtifactKey[] markSet, IArtifactRepository aRepository) {
        final HashSet<IArtifactKey> set = new HashSet<IArtifactKey>(Arrays.asList(markSet));
        ArtifactKeyQuery query = new ArtifactKeyQuery(){

            public boolean isMatch(IArtifactKey candidate) {
                return !set.contains(candidate);
            }
        };
        IQueryResult inactive = aRepository.query((IQuery)query, null);
        Iterator iterator = inactive.iterator();
        while (iterator.hasNext()) {
            IArtifactKey key = (IArtifactKey)iterator.next();
            aRepository.removeDescriptor(key);
            if (!debugMode) continue;
            Tracing.debug((String)("Key removed:" + key));
        }
    }

    public static void setDebugMode(boolean inDebugMode) {
        debugMode = inDebugMode;
    }
}

