/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.core.databinding.beans.BeansObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.riena.internal.ui.ridgets.swt.ActionObserver;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IActionListener;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.ITraverseRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractEditableRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;

public abstract class AbstractTraverseRidget
extends AbstractEditableRidget
implements ITraverseRidget {
    private final ActionObserver actionObserver;
    private final TooltipChangeHandler tooltipChangedHandler;
    protected boolean initialized = false;
    protected int maximum = Integer.MIN_VALUE;
    protected int minimum = Integer.MIN_VALUE;
    protected int increment = Integer.MIN_VALUE;
    protected int pageIncrement = Integer.MIN_VALUE;
    protected int value = Integer.MIN_VALUE;

    public AbstractTraverseRidget() {
        this.actionObserver = new ActionObserver((IRidget)this);
        this.tooltipChangedHandler = new TooltipChangeHandler();
        this.addListener(new ActionListener());
        this.addPropertyChangeListener("tooltip", this.tooltipChangedHandler);
    }

    public final void addListener(IActionListener listener) {
        this.actionObserver.addListener(listener);
    }

    public void triggerListener() {
        this.actionObserver.fireAction(null);
    }

    public void bindUIControl() {
        Control control = this.getUIControl();
        if (control != null) {
            this.initFromUIControl();
            this.addSelectionListener(control, (SelectionListener)this.actionObserver);
            this.updateUIControl();
        }
    }

    public int getIncrement() {
        return this.increment;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public final void removeListener(IActionListener listener) {
        this.actionObserver.removeListener(listener);
    }

    public synchronized boolean revalidate() {
        int value = 0;
        if (this.getUIControl() != null) {
            value = this.getValue();
        }
        this.disableMandatoryMarkers(true);
        IStatus status = this.checkAllRules(value, new AbstractEditableRidget.ValidationCallback(this, false));
        if (status.isOK()) {
            this.getValueBindingSupport().updateFromTarget();
        }
        return !this.isErrorMarked();
    }

    public void setIncrement(int increment) {
        increment = this.preSetIncrement(increment);
        Integer oldValue = this.increment;
        this.increment = increment;
        this.updateUIIncrement();
        this.firePropertyChange("increment", oldValue, this.getIncrement());
    }

    public void setMaximum(int maximum) {
        this.checkMaximum(maximum);
        this.preSetMaximum(maximum);
        Integer oldValue = this.maximum;
        this.maximum = maximum;
        this.updateUIMaximum();
        this.firePropertyChange("maximum", oldValue, this.maximum);
    }

    public void setMinimum(int minimum) {
        this.checkMinimum(minimum);
        this.preSetMinimum(minimum);
        Integer oldValue = this.minimum;
        this.minimum = minimum;
        this.updateUIMinimum();
        this.firePropertyChange("minimum", oldValue, this.minimum);
    }

    public void setPageIncrement(int pageIncrement) {
        pageIncrement = this.preSetPageIncrement(pageIncrement);
        Integer oldValue = this.pageIncrement;
        this.pageIncrement = pageIncrement;
        this.updateUIPageIncrement();
        this.firePropertyChange("pageIncrement", oldValue, this.pageIncrement);
    }

    public void setValue(int value) {
        value = this.preSetValue(value);
        Integer oldValue = this.value;
        this.value = value;
        this.updateUIValue();
        this.tooltipChangedHandler.updateTooltipPattern();
        this.firePropertyChange("value", oldValue, this.value);
    }

    protected abstract void addSelectionListener(Control var1, SelectionListener var2);

    protected void checkMaximum(int maximum) {
        if (maximum <= this.minimum) {
            new Message("The maximum value of %d must be greater than the minimum value of %d", maximum, this.minimum).push();
        }
        if (maximum <= 0) {
            new Message("The maximum value of %d must be greater than zero", maximum).push();
        }
    }

    protected void checkMinimum(int minimum) {
        if (minimum >= this.maximum) {
            new Message("The minimum value of %d must be lower than the maximum value of %d", minimum, this.maximum).push();
        }
        if (minimum < 0) {
            new Message("The minimum value of %d must be greater than zero", minimum).push();
        }
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected IObservableValue getRidgetObservable() {
        return BeansObservables.observeValue((Object)((Object)this), (String)"value");
    }

    protected abstract int getValue(Control var1);

    protected void initFromUIControl() {
        if (this.getUIControl() != null && !this.initialized) {
            if (this.getMaximum() == Integer.MIN_VALUE) {
                this.setMaximum(this.getUIControlMaximum());
            }
            if (this.getMinimum() == Integer.MIN_VALUE) {
                this.setMinimum(this.getUIControlMinimum());
            }
            if (this.getIncrement() == Integer.MIN_VALUE) {
                this.setIncrement(this.getUIControlIncrement());
            }
            if (this.getPageIncrement() == Integer.MIN_VALUE) {
                this.setPageIncrement(this.getUIControlPageIncrement());
            }
            if (this.getValue() == Integer.MIN_VALUE) {
                this.setValue(this.getUIControlSelection());
            }
            this.initAdditionalsFromUIControl();
            this.initialized = true;
        }
    }

    protected abstract void initAdditionalsFromUIControl();

    protected abstract int getUIControlMaximum();

    protected abstract int getUIControlMinimum();

    protected abstract int getUIControlIncrement();

    protected abstract int getUIControlPageIncrement();

    protected abstract int getUIControlSelection();

    protected int preSetIncrement(int increment) {
        if (!this.initialized) {
            return increment;
        }
        if (increment <= 0) {
            increment = 1;
        } else if (increment > this.maximum - this.minimum) {
            increment = this.maximum - this.minimum;
        }
        return increment;
    }

    protected int preSetMaximum(int maximum) {
        int deltaMaxMin;
        if (!this.initialized) {
            return maximum;
        }
        if (maximum < this.value) {
            this.setValue(maximum);
        }
        if ((deltaMaxMin = maximum - this.minimum) < this.increment) {
            this.setIncrement(deltaMaxMin);
        }
        if (deltaMaxMin < this.pageIncrement) {
            this.setPageIncrement(deltaMaxMin);
        }
        return maximum;
    }

    protected int preSetMinimum(int minimum) {
        int deltaMaxMin;
        if (!this.initialized) {
            return minimum;
        }
        if (this.value < minimum) {
            this.setValue(minimum);
        }
        if ((deltaMaxMin = this.maximum - minimum) < this.increment) {
            this.setIncrement(deltaMaxMin);
        }
        if (deltaMaxMin < this.pageIncrement) {
            this.setPageIncrement(deltaMaxMin);
        }
        return minimum;
    }

    protected int preSetPageIncrement(int pageIncrement) {
        if (!this.initialized) {
            return pageIncrement;
        }
        if (pageIncrement <= 0) {
            pageIncrement = 1;
        } else if (pageIncrement > this.maximum - this.minimum) {
            pageIncrement = this.maximum - this.minimum;
        }
        return pageIncrement;
    }

    protected int preSetValue(int value) {
        if (!this.initialized) {
            return value;
        }
        if (value < 0 || value < this.minimum) {
            value = this.getMinimum();
        }
        if (value > this.maximum) {
            value = this.maximum;
        }
        return value;
    }

    protected abstract void removeSelectionListener(Control var1, SelectionListener var2);

    protected String replaceToolTipPattern(String toolTipText) {
        String strgValue = Integer.toString(this.getValue());
        return toolTipText.replace("[VALUE]", strgValue);
    }

    protected void unbindUIControl() {
        super.unbindUIControl();
        Control control = this.getUIControl();
        if (control != null) {
            this.addSelectionListener(control, (SelectionListener)this.actionObserver);
        }
    }

    protected void updateUIControl() {
        this.updateUIMaximum();
        this.updateUIMinimum();
        this.updateUIIncrement();
        this.updateUIPageIncrement();
        this.updateUIValue();
        this.tooltipChangedHandler.updateTooltipPattern();
    }

    protected abstract void updateUIIncrement();

    protected abstract void updateUIMaximum();

    protected abstract void updateUIMinimum();

    protected abstract void updateUIPageIncrement();

    protected abstract void updateUIValue();

    private final class ActionListener
    implements IActionListener {
        private ActionListener() {
        }

        public void callback() {
            if (AbstractTraverseRidget.this.getUIControl() != null) {
                int selection = AbstractTraverseRidget.this.getValue(AbstractTraverseRidget.this.getUIControl());
                AbstractTraverseRidget.this.setValue(selection);
            }
        }
    }

    protected static class Message {
        public static final String MAX_LE_MIN = "The maximum value of %d must be greater than the minimum value of %d";
        public static final String MAX_LE_ZERO = "The maximum value of %d must be greater than zero";
        public static final String MIN_GE_MAX = "The minimum value of %d must be lower than the maximum value of %d";
        public static final String MIN_LT_ZERO = "The minimum value of %d must be greater than zero";
        private String message;

        protected Message(String msgConstant, Object ... attributes) {
            this.message = String.format(msgConstant, attributes);
        }

        protected void push() {
            throw new IllegalArgumentException(this.message);
        }
    }

    private final class TooltipChangeHandler
    implements PropertyChangeListener {
        private String acceptedPatternTooltip;
        private boolean updateMode;

        private TooltipChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (this.updateMode) {
                return;
            }
            String newValue = (String)event.getNewValue();
            if (newValue == null || newValue.equals("")) {
                this.acceptedPatternTooltip = null;
                return;
            }
            boolean replace = true;
            if (newValue.contains("[VALUE]")) {
                this.acceptedPatternTooltip = newValue;
            } else if (this.acceptedPatternTooltip != null) {
                String testReplaced = AbstractTraverseRidget.this.replaceToolTipPattern(this.acceptedPatternTooltip);
                if (!testReplaced.equals(newValue)) {
                    this.acceptedPatternTooltip = null;
                } else {
                    replace = false;
                }
            } else {
                this.acceptedPatternTooltip = null;
            }
            if (replace) {
                this.updateTooltipPattern();
            }
        }

        protected void updateTooltipPattern() {
            Control control = AbstractTraverseRidget.this.getUIControl();
            if (control == null) {
                return;
            }
            if (this.acceptedPatternTooltip != null) {
                String toolTipText = AbstractTraverseRidget.this.replaceToolTipPattern(this.acceptedPatternTooltip);
                try {
                    this.updateMode = true;
                    AbstractTraverseRidget.this.setToolTipText(toolTipText);
                }
                finally {
                    this.updateMode = false;
                }
            }
        }
    }
}

