/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.swt.lnf.LnfManager;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Tree;

public class DisabledMarkerVisualizer {
    private static final DisabledPainter DISABLED_MARKER_PAINTER = new DisabledPainter();
    private final IRidget ridget;
    private RenderMemento renderMemento;

    public DisabledMarkerVisualizer(IRidget ridget) {
        this.ridget = ridget;
    }

    public void updateDisabled() {
        this.updateDisabled(this.getControl(), this.getRidget().isEnabled());
    }

    private void updateDisabled(Control control, boolean enabled) {
        control.setEnabled(enabled);
        this.removePaintlistener(control);
        if (!enabled) {
            this.addPaintlistener(control);
        }
        if (control instanceof Composite) {
            Control[] children;
            Composite composite = (Composite)control;
            Control[] controlArray = children = composite.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.updateDisabled(child, enabled);
                ++n2;
            }
        }
        control.redraw();
    }

    protected void removePaintlistener(Control control) {
        control.removePaintListener((PaintListener)DISABLED_MARKER_PAINTER);
    }

    protected void addPaintlistener(Control control) {
        control.addPaintListener((PaintListener)DISABLED_MARKER_PAINTER);
    }

    private Control getControl() {
        return (Control)this.getRidget().getUIControl();
    }

    private IRidget getRidget() {
        return this.ridget;
    }

    private RenderMemento storeState() {
        RenderMemento result = new RenderMemento();
        Control control = this.getControl();
        if (control instanceof Tree) {
            Tree tree = (Tree)control;
            result.headerVisible = tree.getHeaderVisible();
        } else if (control instanceof Table) {
            Table table = (Table)control;
            result.headerVisible = table.getHeaderVisible();
        }
        return result;
    }

    private void setHeaderVisible(boolean headerVisible) {
        Control control = this.getControl();
        if (control instanceof Tree) {
            Tree tree = (Tree)control;
            tree.setHeaderVisible(headerVisible);
        } else if (control instanceof Table) {
            Table table = (Table)control;
            table.setHeaderVisible(headerVisible);
        }
    }

    private static final class DisabledPainter
    implements PaintListener {
        private DisabledPainter() {
        }

        public void paintControl(PaintEvent e) {
            GC gc = e.gc;
            Control control = (Control)e.widget;
            int alpha = LnfManager.getLnf().getIntegerSetting("DisabledMarker.standardAlpha");
            gc.setAlpha(alpha);
            Color color = LnfManager.getLnf().getColor("DisabledMarker.backgroundColor");
            gc.setBackground(color);
            Rectangle bounds = control.getBounds();
            gc.fillRectangle(0, 0, bounds.width, bounds.height);
        }
    }

    private static final class RenderMemento {
        boolean headerVisible;

        private RenderMemento() {
        }
    }
}

