/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.DefaultActionManager;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IDefaultActionManager;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.listener.IWindowRidgetListener;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.riena.ui.swt.EmbeddedTitleBar;
import org.eclipse.riena.ui.swt.IEmbeddedTitleBarListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Image;

public class EmbeddedTitleBarRidget
extends AbstractSWTRidget
implements IWindowRidget {
    private static final String EMPTY_STRING = "";
    private String text = "";
    private String icon;
    private ListenerList<IWindowRidgetListener> windowRidgetListeners = new ListenerList(IWindowRidgetListener.class);
    private boolean closeable = true;
    private boolean active = true;
    private IEmbeddedTitleBarListener titleBarListener = new TitleBarListener();
    private DefaultActionManager actionManager;

    public EmbeddedTitleBarRidget() {
    }

    public EmbeddedTitleBarRidget(EmbeddedTitleBar window) {
        this();
        this.setUIControl(window);
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    public EmbeddedTitleBar getUIControl() {
        return (EmbeddedTitleBar)super.getUIControl();
    }

    public void setTitle(String title) {
        String oldValue = this.text;
        this.text = title;
        this.updateTextInControl();
        this.firePropertyChange("text", oldValue, this.text);
    }

    public String getTitle() {
        return this.text;
    }

    public void setIcon(String icon) {
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon)) {
            this.updateIconInControl();
        }
    }

    public String getIcon() {
        return this.icon;
    }

    protected void bindUIControl() {
        this.updateTextInControl();
        if (this.getUIControl() != null) {
            this.getUIControl().addEmbeddedTitleBarListener(this.titleBarListener);
        }
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, EmbeddedTitleBar.class);
    }

    protected void unbindUIControl() {
        super.unbindUIControl();
        if (this.getUIControl() != null) {
            this.getUIControl().removeEmbeddedTitleBarListener(this.titleBarListener);
        }
    }

    public IDefaultActionManager addDefaultAction(IRidget focusRidget, IActionRidget actionRidget) {
        if (this.actionManager == null) {
            this.actionManager = new DefaultActionManager(this);
        }
        this.actionManager.addAction(focusRidget, actionRidget);
        return this.actionManager;
    }

    public void addWindowRidgetListener(IWindowRidgetListener listener) {
        this.windowRidgetListeners.add((Object)listener);
    }

    public void dispose() {
        this.getUIControl().dispose();
        if (this.actionManager != null) {
            this.actionManager.dispose();
            this.actionManager = null;
        }
    }

    public Object getDefaultButton() {
        return null;
    }

    public boolean isDisableMandatoryMarker() {
        return true;
    }

    public void layout() {
        EmbeddedTitleBar control = this.getUIControl();
        if (control != null) {
            control.getParent().layout(true, true);
        }
    }

    public void removeWindowRidgetListener(IWindowRidgetListener listener) {
        this.windowRidgetListeners.remove((Object)listener);
    }

    public void setDefaultButton(Object defaultButton) {
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            this.active = active;
            this.updateActive();
        }
    }

    public void setCloseable(boolean closeable) {
        if (this.closeable != closeable) {
            this.closeable = closeable;
            this.updateCloseable();
        }
    }

    private void updateTextInControl() {
        EmbeddedTitleBar control = this.getUIControl();
        if (control != null) {
            control.setTitle(this.text);
        }
    }

    private void updateIconInControl() {
        EmbeddedTitleBar control = this.getUIControl();
        if (control != null) {
            Image image = null;
            if (this.icon != null) {
                image = this.getManagedImage(this.icon);
            }
            control.setImage(image);
        }
    }

    private void updateCloseable() {
        EmbeddedTitleBar control = this.getUIControl();
        if (control != null) {
            control.setCloseable(this.closeable);
        }
    }

    private void updateActive() {
        EmbeddedTitleBar control = this.getUIControl();
        if (control != null) {
            control.setWindowActive(this.active);
        }
    }

    private class TitleBarListener
    implements IEmbeddedTitleBarListener {
        private TitleBarListener() {
        }

        public void windowActivated(MouseEvent e) {
            IWindowRidgetListener[] iWindowRidgetListenerArray = (IWindowRidgetListener[])EmbeddedTitleBarRidget.this.windowRidgetListeners.getListeners();
            int n = iWindowRidgetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWindowRidgetListener listener = iWindowRidgetListenerArray[n2];
                listener.activated();
                ++n2;
            }
        }

        public void windowClosed(MouseEvent e) {
            IWindowRidgetListener[] iWindowRidgetListenerArray = (IWindowRidgetListener[])EmbeddedTitleBarRidget.this.windowRidgetListeners.getListeners();
            int n = iWindowRidgetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWindowRidgetListener listener = iWindowRidgetListenerArray[n2];
                listener.closed();
                ++n2;
            }
        }
    }
}

