/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.jface.viewers.AbstractListViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.riena.ui.ridgets.ISelectableRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractListRidget;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTRidget;
import org.eclipse.riena.ui.ridgets.swt.MarkerSupport;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.List;

public class ListRidget
extends AbstractListRidget {
    private ListViewer viewer;

    public ListRidget() {
        this.selectionTypeEnforcer = new SelectionTypeEnforcer();
    }

    protected void checkUIControl(Object uiControl) {
        AbstractSWTRidget.assertType(uiControl, List.class);
    }

    public List getUIControl() {
        return (List)super.getUIControl();
    }

    protected int getUIControlSelectionIndex() {
        return this.getUIControl().getSelectionIndex();
    }

    protected int[] getUIControlSelectionIndices() {
        return this.getUIControl().getSelectionIndices();
    }

    protected int getUIControlItemCount() {
        return this.getUIControl().getItemCount();
    }

    protected void bindUIControl() {
        List control = this.getUIControl();
        if (control != null) {
            this.viewer = new ListViewer(control);
            if (this.hasViewerModel()) {
                this.configureViewer((AbstractListViewer)this.viewer);
            }
            this.updateComparator();
            this.updateEnabled(this.isEnabled());
            control.addSelectionListener(this.selectionTypeEnforcer);
            control.addMouseListener(this.doubleClickForwarder);
        }
    }

    protected void unbindUIControl() {
        super.unbindUIControl();
        List control = this.getUIControl();
        if (control != null) {
            control.removeSelectionListener(this.selectionTypeEnforcer);
            control.removeMouseListener(this.doubleClickForwarder);
        }
        this.viewer = null;
    }

    protected AbstractListViewer getViewer() {
        return this.viewer;
    }

    protected void updateEnabled(boolean isEnabled) {
        if (isEnabled) {
            if (this.hasViewer()) {
                this.refreshViewer();
                this.disposeSelectionBindings();
                this.createSelectionBindings();
                List list = this.viewer.getList();
                list.setBackground((Color)list.getData("oldbg"));
                list.setData("oldbg", null);
            }
        } else {
            this.disposeSelectionBindings();
            if (this.hasViewer()) {
                this.refreshViewer();
                List list = this.viewer.getList();
                if (MarkerSupport.isHideDisabledRidgetContent()) {
                    list.deselectAll();
                }
                list.setData("oldbg", (Object)list.getBackground());
                list.setBackground(list.getDisplay().getSystemColor(22));
            }
        }
    }

    private final class SelectionTypeEnforcer
    extends SelectionAdapter {
        private SelectionTypeEnforcer() {
        }

        public void widgetSelected(SelectionEvent e) {
            List control = (List)e.widget;
            if (ListRidget.this.isOutputOnly()) {
                this.revertSelection(control);
            } else if (ISelectableRidget.SelectionType.SINGLE.equals((Object)ListRidget.this.getSelectionType()) && control.getSelectionCount() > 1) {
                e.doit = false;
                this.selectFirstItem(control);
            }
        }

        private void selectFirstItem(List control) {
            control.setSelection(control.getSelectionIndex());
            Event event = new Event();
            event.type = 13;
            event.doit = true;
            control.notifyListeners(13, event);
        }

        private void revertSelection(List control) {
            control.setRedraw(false);
            try {
                ListRidget.this.viewer.setSelection((ISelection)new StructuredSelection(ListRidget.this.getSelection()));
            }
            finally {
                control.setRedraw(true);
            }
        }
    }
}

