/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.riena.internal.ui.ridgets.swt;

import org.eclipse.riena.core.util.ListenerList;
import org.eclipse.riena.internal.ui.ridgets.swt.DefaultActionManager;
import org.eclipse.riena.ui.core.marker.HiddenMarker;
import org.eclipse.riena.ui.ridgets.AbstractMarkerSupport;
import org.eclipse.riena.ui.ridgets.IActionRidget;
import org.eclipse.riena.ui.ridgets.IDefaultActionManager;
import org.eclipse.riena.ui.ridgets.IRidget;
import org.eclipse.riena.ui.ridgets.IWindowRidget;
import org.eclipse.riena.ui.ridgets.UIBindingFailure;
import org.eclipse.riena.ui.ridgets.listener.IWindowRidgetListener;
import org.eclipse.riena.ui.ridgets.swt.AbstractSWTWidgetRidget;
import org.eclipse.riena.ui.ridgets.swt.BasicMarkerSupport;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Shell;

public class ShellRidget
extends AbstractSWTWidgetRidget
implements IWindowRidget {
    private boolean closeable = true;
    private boolean titleAlreadyInitialized = false;
    private String title = "";
    private String icon;
    private ListenerList<IWindowRidgetListener> windowRidgetListeners = new ListenerList(IWindowRidgetListener.class);
    private DefaultActionManager actionManager;
    private ShellListener shellListener = new RidgetShellListener();

    public ShellRidget() {
    }

    public ShellRidget(Shell shell) {
        this();
        this.setUIControl(shell);
    }

    public IDefaultActionManager addDefaultAction(IRidget focusRidget, IActionRidget actionRidget) {
        if (this.actionManager == null) {
            this.actionManager = new DefaultActionManager(this);
        }
        this.actionManager.addAction(focusRidget, actionRidget);
        return this.actionManager;
    }

    public void addWindowRidgetListener(IWindowRidgetListener listener) {
        this.windowRidgetListeners.add((Object)listener);
    }

    public void dispose() {
        Shell control = this.getUIControl();
        if (control != null) {
            control.dispose();
        }
        if (this.actionManager != null) {
            this.actionManager.dispose();
            this.actionManager = null;
        }
    }

    public Object getDefaultButton() {
        return this.getUIControl().getDefaultButton();
    }

    public String getTitle() {
        return this.title;
    }

    public Shell getUIControl() {
        return (Shell)super.getUIControl();
    }

    public boolean hasFocus() {
        if (this.getUIControl() != null) {
            return this.getUIControl().isFocusControl();
        }
        return false;
    }

    public boolean isDisableMandatoryMarker() {
        return false;
    }

    public boolean isVisible() {
        if (!this.getMarkersOfType(HiddenMarker.class).isEmpty()) {
            return false;
        }
        if (this.getUIControl() != null) {
            return this.getUIControl().isVisible();
        }
        return this.savedVisibleState;
    }

    public void layout() {
        Shell control = this.getUIControl();
        if (control != null) {
            control.layout(true, true);
        }
    }

    public void removeWindowRidgetListener(IWindowRidgetListener listener) {
        this.windowRidgetListeners.remove((Object)listener);
    }

    public void requestFocus() {
        if (this.getUIControl() != null) {
            this.getUIControl().setFocus();
        }
    }

    public void setActive(boolean active) {
        this.setEnabled(active);
    }

    public void setCloseable(boolean closeable) {
        if (this.closeable != closeable) {
            this.closeable = closeable;
            this.updateCloseable();
        }
    }

    public void setDefaultButton(Object defaultButton) {
        if (defaultButton instanceof Button) {
            this.getUIControl().setDefaultButton((Button)defaultButton);
        }
    }

    public void setIcon(String icon) {
        String oldIcon = this.icon;
        this.icon = icon;
        if (this.hasChanged(oldIcon, icon)) {
            this.updateIcon();
        }
    }

    public void setTitle(String title) {
        this.titleAlreadyInitialized = true;
        if (title != null && !this.title.equals(title)) {
            this.title = title;
            this.updateTitle();
        }
    }

    public void updateFromModel() {
        super.updateFromModel();
        if (this.getUIControl() != null) {
            this.updateTitle();
            this.updateIcon();
        }
    }

    protected void bindUIControl() {
        this.addShellListener();
        this.updateToolTip();
        this.updateCloseable();
        this.updateTitle();
        this.updateIcon();
    }

    protected void checkUIControl(Object uiControl) {
        if (uiControl != null && !(uiControl instanceof Shell)) {
            throw new UIBindingFailure("uiControl of a ShellRidget must be a Shell but was a " + uiControl.getClass().getSimpleName());
        }
    }

    protected AbstractMarkerSupport createMarkerSupport() {
        return new BasicMarkerSupport(this, this.propertyChangeSupport);
    }

    protected boolean hasChanged(Object oldValue, Object newValue) {
        if (oldValue == null && newValue == null) {
            return false;
        }
        if (oldValue == null || newValue == null) {
            return true;
        }
        return !oldValue.equals(newValue);
    }

    protected void unbindUIControl() {
        this.savedVisibleState = this.isVisible();
        this.removeShellListener();
    }

    protected void updateEnabled() {
        if (this.getUIControl() != null) {
            this.getUIControl().setEnabled(this.isEnabled());
        }
    }

    protected void updateToolTip() {
        if (this.getUIControl() != null) {
            this.getUIControl().setToolTipText(this.getToolTipText());
        }
    }

    private void addShellListener() {
        if (this.getUIControl() != null) {
            this.getUIControl().addShellListener(this.shellListener);
        }
    }

    private void removeShellListener() {
        if (this.getUIControl() != null) {
            this.getUIControl().removeShellListener(this.shellListener);
        }
    }

    private void updateCloseable() {
    }

    private void updateIcon() {
        Shell control = this.getUIControl();
        if (control != null) {
            Image image = null;
            if (this.icon != null) {
                image = this.getManagedImage(this.icon);
            }
            control.setImage(image);
        }
    }

    private void updateTitle() {
        if (this.getUIControl() != null) {
            if (this.titleAlreadyInitialized) {
                this.getUIControl().setText(this.title);
            } else {
                this.titleAlreadyInitialized = true;
                this.title = this.getUIControl().getText();
            }
        }
    }

    private final class RidgetShellListener
    extends ShellAdapter {
        private RidgetShellListener() {
        }

        public void shellActivated(ShellEvent e) {
            IWindowRidgetListener[] iWindowRidgetListenerArray = (IWindowRidgetListener[])ShellRidget.this.windowRidgetListeners.getListeners();
            int n = iWindowRidgetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWindowRidgetListener l = iWindowRidgetListenerArray[n2];
                l.activated();
                ++n2;
            }
        }

        public void shellClosed(ShellEvent e) {
            IWindowRidgetListener[] iWindowRidgetListenerArray = (IWindowRidgetListener[])ShellRidget.this.windowRidgetListeners.getListeners();
            int n = iWindowRidgetListenerArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWindowRidgetListener l = iWindowRidgetListenerArray[n2];
                l.closed();
                ++n2;
            }
        }
    }
}

